//  Author: Chris Campbell - www.iforce2d.net
//  -----------------------------------------
//
//  only for this demo project, you can remove this in your own app
//

#import "ExamplesMenuLayer.h"

#import "BasicRUBELayer.h"
#import "RUBELayer.h"
#import "DestroyBodyLayer.h"
#import "PinballRUBELayer.h"
#import "PlanetCuteRUBELayer.h"

@implementation ExamplesMenuLayer

+(CCScene *) scene
{
	CCScene *scene = [CCScene node];
	ExamplesMenuLayer *layer = [ExamplesMenuLayer node];
	
	[scene addChild: layer];
    
	return scene;
}

-(id) init
{
	if( (self=[super init])) {                
        
        self.isTouchEnabled = YES;        
        
        CCMenuItem* basicItem = [CCMenuItemFont itemFromString:@"Basic load" target:self selector:@selector(loadBasic:)];
        CCMenuItem* imagesItem = [CCMenuItemFont itemFromString:@"Images load" target:self selector:@selector(loadImages:)];
        CCMenuItem* destroyItem = [CCMenuItemFont itemFromString:@"Destroy bodies" target:self selector:@selector(loadDestroy:)];
        CCMenuItem* pinballItem = [CCMenuItemFont itemFromString:@"Pinball demo" target:self selector:@selector(loadPinball:)];
        CCMenuItem* planetCuteItem = [CCMenuItemFont itemFromString:@"PlanetCute demo" target:self selector:@selector(loadPlanetCute:)];
        CCMenu* menu = [CCMenu menuWithItems:basicItem,imagesItem,destroyItem,pinballItem,planetCuteItem,nil];
        [menu alignItemsVertically];
        [self addChild:menu];
        
	}
	return self;
}

-(void)loadBasic:(id)item
{
    [[CCDirector sharedDirector] replaceScene:[BasicRUBELayer scene]];
}

-(void)loadImages:(id)item
{
    [[CCDirector sharedDirector] replaceScene:[RUBELayer scene]];
}

-(void)loadDestroy:(id)item
{
    [[CCDirector sharedDirector] replaceScene:[DestroyBodyLayer scene]];
}

-(void)loadPinball:(id)item
{
    [[CCDirector sharedDirector] replaceScene:[PinballRUBELayer scene]];
}

-(void)loadPlanetCute:(id)item
{
    [[CCDirector sharedDirector] replaceScene:[PlanetCuteRUBELayer scene]];
}

@end

