/*
* Author: Chris Campbell - www.iforce2d.net
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

#ifndef b2dJsonImage_SDL2_H
#define b2dJsonImage_SDL2_H

#include <SDL2/SDL.h>
#include <SDL2/SDL_image.h>
#include "rubestuff/b2dJsonImage.h"

class b2dJsonImage_SDL2 : public b2dJsonImage {
public:
    SDL_Texture* m_texture;
public:
    b2dJsonImage_SDL2( const b2dJsonImage* other );
    ~b2dJsonImage_SDL2();

    bool loadImage();
    void render(float ptm, SDL_Point worldOrigin);

    void setAlpha(float a);
};

#endif // b2dJsonImage_SDL2_H
