/*
* Author: Chris Campbell - www.iforce2d.net
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

#include <SDL2/SDL_image.h>
#include "b2dJsonImage_SDL2.h"
#include "Window.h"

#include <iostream>
using namespace std;

#ifndef DEGTORAD
#define DEGTORAD 0.0174532925199432957f
#define RADTODEG 57.295779513082320876f
#endif

b2dJsonImage_SDL2::b2dJsonImage_SDL2(const b2dJsonImage *other) : b2dJsonImage(other)
{
    loadImage();
}

b2dJsonImage_SDL2::~b2dJsonImage_SDL2()
{
    SDL_DestroyTexture(m_texture);
}

bool b2dJsonImage_SDL2::loadImage()
{
    m_texture = IMG_LoadTexture(getRenderer(),file.c_str());
    if (!m_texture) {
        cout << "Could not load image: " << file << endl;
		std::cout << "IMG_LoadTexture error: " << SDL_GetError() << std::endl;
        return false;
    }

    //m_sprite.setOrigin( 0.5 * rect.width, 0.5 * rect.height );
    //m_sprite.setColor( sf::Color(colorTint[0], colorTint[1], colorTint[2], colorTint[3] * opacity) ); //CCTODO
    SDL_SetTextureColorMod(m_texture, colorTint[0], colorTint[1], colorTint[2]);
    SDL_SetTextureAlphaMod(m_texture, (uint8)(colorTint[3] * opacity));

    cout << "Loaded image: " << file << endl;

    return false;
}

void b2dJsonImage_SDL2::render(float ptm, SDL_Point worldOrigin)
{
    int w,h;
    SDL_QueryTexture(m_texture, NULL, NULL, &w, &h);
    float s = ptm * scale / (float)h;
    //m_sprite.setScale(aspectScale * s * (flip?-1:1),s); //CCTODO

    b2Vec2 pos = center;
    float ang = -angle;
    if ( body ) {
        //need to rotate image local center by body angle
        b2Vec2 localPos( pos.x, pos.y );
        b2Rot rot( body->GetAngle() );
        localPos = b2Mul(rot, localPos) + body->GetPosition();
        pos.x = localPos.x;
        pos.y = localPos.y;
        ang += -body->GetAngle();
    }

    SDL_Point center;
    center.x = w/2;
    center.y = h/2;

    SDL_Rect texr;
    texr.w = (int)(w * aspectScale * s * (flip?-1.0f:1.0f));
    texr.h = (int)(h * s);
    texr.x = (int)(worldOrigin.x + ptm * pos.x - texr.w/2);
    texr.y = (int)(worldOrigin.y + ptm * -pos.y - texr.h/2);
    SDL_RenderCopyEx(getRenderer(), m_texture, NULL, &texr, ang * RADTODEG, NULL, SDL_FLIP_NONE);
}

void b2dJsonImage_SDL2::setAlpha(float a)
{
    SDL_SetTextureAlphaMod(m_texture, (int)(colorTint[3] * opacity * a));
}





