/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class TheoJansen
extends TestbedTest {
    private static final long CHASSIS_TAG = 1L;
    private static final long WHEEL_TAG = 2L;
    private static final long MOTOR_TAG = 8L;
    Vec2 m_offset = new Vec2();
    Body m_chassis;
    Body m_wheel;
    RevoluteJoint m_motorJoint;
    boolean m_motorOn;
    float m_motorSpeed;

    @Override
    public Long getTag(Body argBody) {
        if (argBody == this.m_chassis) {
            return 1L;
        }
        if (argBody == this.m_wheel) {
            return 2L;
        }
        return null;
    }

    @Override
    public Long getTag(Joint argJoint) {
        if (argJoint == this.m_motorJoint) {
            return 8L;
        }
        return null;
    }

    @Override
    public void processBody(Body argBody, Long argTag) {
        if (argTag == 1L) {
            this.m_chassis = argBody;
        } else if (argTag == 2L) {
            this.m_wheel = argBody;
        }
    }

    @Override
    public void processJoint(Joint argJoint, Long argTag) {
        if (argTag == 8L) {
            this.m_motorJoint = (RevoluteJoint)argJoint;
            this.m_motorOn = this.m_motorJoint.m_enableMotor;
        }
    }

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean argDeserialized) {
        BodyDef bd;
        if (argDeserialized) {
            return;
        }
        this.m_offset.set(0.0f, 8.0f);
        this.m_motorSpeed = 2.0f;
        this.m_motorOn = true;
        Vec2 pivot = new Vec2(0.0f, 0.8f);
        BodyDef bd2 = new BodyDef();
        Body ground = this.getWorld().createBody(bd2);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-50.0f, 0.0f), new Vec2(50.0f, 0.0f));
        ground.createFixture(shape, 0.0f);
        shape.set(new Vec2(-50.0f, 0.0f), new Vec2(-50.0f, 10.0f));
        ground.createFixture(shape, 0.0f);
        shape.set(new Vec2(50.0f, 0.0f), new Vec2(50.0f, 10.0f));
        ground.createFixture(shape, 0.0f);
        for (int i = 0; i < 40; ++i) {
            CircleShape shape2 = new CircleShape();
            shape2.m_radius = 0.25f;
            bd = new BodyDef();
            bd.type = BodyType.DYNAMIC;
            bd.position.set(-40.0f + 2.0f * (float)i, 0.5f);
            Body body = this.getWorld().createBody(bd);
            body.createFixture(shape2, 1.0f);
        }
        Shape shape3 = new PolygonShape();
        shape3.setAsBox(2.5f, 1.0f);
        FixtureDef sd = new FixtureDef();
        sd.density = 1.0f;
        sd.shape = shape3;
        sd.filter.groupIndex = -1;
        bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.position.set(pivot).addLocal(this.m_offset);
        this.m_chassis = this.getWorld().createBody(bd);
        this.m_chassis.createFixture(sd);
        shape3 = new CircleShape();
        ((CircleShape)shape3).m_radius = 1.6f;
        sd = new FixtureDef();
        sd.density = 1.0f;
        sd.shape = shape3;
        sd.filter.groupIndex = -1;
        bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.position.set(pivot).addLocal(this.m_offset);
        this.m_wheel = this.getWorld().createBody(bd);
        this.m_wheel.createFixture(sd);
        RevoluteJointDef jd = new RevoluteJointDef();
        jd.initialize(this.m_wheel, this.m_chassis, pivot.add(this.m_offset));
        jd.collideConnected = false;
        jd.motorSpeed = this.m_motorSpeed;
        jd.maxMotorTorque = 400.0f;
        jd.enableMotor = this.m_motorOn;
        this.m_motorJoint = (RevoluteJoint)this.getWorld().createJoint(jd);
        Vec2 wheelAnchor = pivot.add(new Vec2(0.0f, -0.8f));
        this.createLeg(-1.0f, wheelAnchor);
        this.createLeg(1.0f, wheelAnchor);
        this.m_wheel.setTransform(this.m_wheel.getPosition(), 2.0943952f);
        this.createLeg(-1.0f, wheelAnchor);
        this.createLeg(1.0f, wheelAnchor);
        this.m_wheel.setTransform(this.m_wheel.getPosition(), -2.0943952f);
        this.createLeg(-1.0f, wheelAnchor);
        this.createLeg(1.0f, wheelAnchor);
    }

    void createLeg(float s, Vec2 wheelAnchor) {
        Vec2[] vertices;
        Vec2 p1 = new Vec2(5.4f * s, -6.1f);
        Vec2 p2 = new Vec2(7.2f * s, -1.2f);
        Vec2 p3 = new Vec2(4.3f * s, -1.9f);
        Vec2 p4 = new Vec2(3.1f * s, 0.8f);
        Vec2 p5 = new Vec2(6.0f * s, 1.5f);
        Vec2 p6 = new Vec2(2.5f * s, 3.7f);
        FixtureDef fd1 = new FixtureDef();
        FixtureDef fd2 = new FixtureDef();
        fd1.filter.groupIndex = -1;
        fd2.filter.groupIndex = -1;
        fd1.density = 1.0f;
        fd2.density = 1.0f;
        PolygonShape poly1 = new PolygonShape();
        PolygonShape poly2 = new PolygonShape();
        if (s > 0.0f) {
            vertices = new Vec2[]{p1, p2, p3};
            poly1.set(vertices, 3);
            vertices[0] = new Vec2();
            vertices[1] = p5.sub(p4);
            vertices[2] = p6.sub(p4);
            poly2.set(vertices, 3);
        } else {
            vertices = new Vec2[]{p1, p3, p2};
            poly1.set(vertices, 3);
            vertices[0] = new Vec2();
            vertices[1] = p6.sub(p4);
            vertices[2] = p5.sub(p4);
            poly2.set(vertices, 3);
        }
        fd1.shape = poly1;
        fd2.shape = poly2;
        BodyDef bd1 = new BodyDef();
        BodyDef bd2 = new BodyDef();
        bd1.type = BodyType.DYNAMIC;
        bd2.type = BodyType.DYNAMIC;
        bd1.position = this.m_offset;
        bd2.position = p4.add(this.m_offset);
        bd1.angularDamping = 10.0f;
        bd2.angularDamping = 10.0f;
        Body body1 = this.getWorld().createBody(bd1);
        Body body2 = this.getWorld().createBody(bd2);
        body1.createFixture(fd1);
        body2.createFixture(fd2);
        DistanceJointDef djd = new DistanceJointDef();
        djd.dampingRatio = 0.5f;
        djd.frequencyHz = 10.0f;
        djd.initialize(body1, body2, p2.add(this.m_offset), p5.add(this.m_offset));
        this.getWorld().createJoint(djd);
        djd.initialize(body1, body2, p3.add(this.m_offset), p4.add(this.m_offset));
        this.getWorld().createJoint(djd);
        djd.initialize(body1, this.m_wheel, p3.add(this.m_offset), wheelAnchor.add(this.m_offset));
        this.getWorld().createJoint(djd);
        djd.initialize(body2, this.m_wheel, p6.add(this.m_offset), wheelAnchor.add(this.m_offset));
        this.getWorld().createJoint(djd);
        RevoluteJointDef rjd = new RevoluteJointDef();
        rjd.initialize(body2, this.m_chassis, p4.add(this.m_offset));
        this.getWorld().createJoint(rjd);
    }

    @Override
    public void keyPressed(char key, int argKeyCode) {
        switch (key) {
            case 'a': {
                this.m_motorJoint.setMotorSpeed(-this.m_motorSpeed);
                break;
            }
            case 's': {
                this.m_motorJoint.setMotorSpeed(0.0f);
                break;
            }
            case 'd': {
                this.m_motorJoint.setMotorSpeed(this.m_motorSpeed);
                break;
            }
            case 'm': {
                this.m_motorJoint.enableMotor(!this.m_motorJoint.isMotorEnabled());
            }
        }
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("Keys: left = a, brake = s, right = d, toggle motor = m");
    }

    @Override
    public String getTestName() {
        return "TheoJansen Walker";
    }
}

