/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.PrismaticJoint;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class PrismaticTest
extends TestbedTest {
    PrismaticJoint m_joint;

    @Override
    public void initTest(boolean argDeserialized) {
        Body ground = null;
        BodyDef bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        ground.createFixture(shape, 0.0f);
        PolygonShape shape2 = new PolygonShape();
        shape2.setAsBox(2.0f, 0.5f);
        BodyDef bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        bd2.position.set(-10.0f, 10.0f);
        bd2.angle = 1.5707964f;
        bd2.allowSleep = false;
        Body body = this.getWorld().createBody(bd2);
        body.createFixture(shape2, 5.0f);
        PrismaticJointDef pjd = new PrismaticJointDef();
        Vec2 axis = new Vec2(2.0f, 1.0f);
        axis.normalize();
        pjd.initialize(ground, body, new Vec2(0.0f, 0.0f), axis);
        pjd.motorSpeed = 10.0f;
        pjd.maxMotorForce = 10000.0f;
        pjd.enableMotor = true;
        pjd.lowerTranslation = 0.0f;
        pjd.upperTranslation = 20.0f;
        pjd.enableLimit = true;
        this.m_joint = (PrismaticJoint)this.getWorld().createJoint(pjd);
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("Keys: (l) limits, (m) motors, (s) speed");
        float force = this.m_joint.getMotorForce(1.0f);
        this.addTextLine("Motor Force = " + force);
    }

    @Override
    public void keyPressed(char argKeyChar, int argKeyCode) {
        switch (argKeyChar) {
            case 'l': {
                this.m_joint.enableLimit(!this.m_joint.isLimitEnabled());
                this.getModel().getKeys()[108] = false;
                break;
            }
            case 'm': {
                this.m_joint.enableMotor(!this.m_joint.isMotorEnabled());
                this.getModel().getKeys()[109] = false;
                break;
            }
            case 's': {
                this.m_joint.setMotorSpeed(-this.m_joint.getMotorSpeed());
                this.getModel().getKeys()[115] = false;
            }
        }
    }

    @Override
    public String getTestName() {
        return "Prismatic";
    }
}

