/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.testbed.framework.TestbedTest;

public class OneSidedTest
extends TestbedTest {
    float m_radius;
    float m_top;
    float m_bottom;
    State m_state;
    Fixture m_platform;
    Fixture m_character;

    @Override
    public String getTestName() {
        return "One Sided";
    }

    @Override
    public void initTest(boolean argDeserialized) {
        BodyDef bd = new BodyDef();
        Body ground = this.getWorld().createBody(bd);
        Shape shape = new EdgeShape();
        ((EdgeShape)shape).set(new Vec2(-20.0f, 0.0f), new Vec2(20.0f, 0.0f));
        ground.createFixture(shape, 0.0f);
        bd = new BodyDef();
        bd.position.set(0.0f, 10.0f);
        Body body = this.getWorld().createBody(bd);
        shape = new PolygonShape();
        ((PolygonShape)shape).setAsBox(3.0f, 0.5f);
        this.m_platform = body.createFixture(shape, 0.0f);
        this.m_bottom = 9.5f;
        this.m_top = 10.5f;
        bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.position.set(0.0f, 12.0f);
        body = this.getWorld().createBody(bd);
        this.m_radius = 0.5f;
        shape = new CircleShape();
        ((CircleShape)shape).m_radius = this.m_radius;
        this.m_character = body.createFixture(shape, 20.0f);
        body.setLinearVelocity(new Vec2(0.0f, -50.0f));
        this.m_state = State.e_unknown;
    }

    @Override
    public void preSolve(Contact contact, Manifold oldManifold) {
        super.preSolve(contact, oldManifold);
        Fixture fixtureA = contact.getFixtureA();
        Fixture fixtureB = contact.getFixtureB();
        if (fixtureA != this.m_platform && fixtureA != this.m_character) {
            return;
        }
        if (fixtureB != this.m_character && fixtureB != this.m_character) {
            return;
        }
        Vec2 position = this.m_character.getBody().getPosition();
        if (position.y < this.m_top + this.m_radius - 0.015f) {
            contact.setEnabled(false);
        }
    }

    static enum State {
        e_unknown,
        e_above,
        e_below;

    }
}

