/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.LineJointDef;
import org.jbox2d.testbed.framework.TestbedTest;

public class LineJointTest
extends TestbedTest {
    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean argDeserialized) {
        if (argDeserialized) {
            return;
        }
        Body ground = null;
        Shape shape = new EdgeShape();
        ((EdgeShape)shape).set(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        BodyDef bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        ground.createFixture(shape, 0.0f);
        shape = new PolygonShape();
        ((PolygonShape)shape).setAsBox(0.5f, 2.0f);
        bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.position.set(0.0f, 7.0f);
        Body body = this.getWorld().createBody(bd);
        body.createFixture(shape, 1.0f);
        LineJointDef jd = new LineJointDef();
        Vec2 axis = new Vec2(2.0f, 1.0f);
        axis.normalize();
        jd.initialize(ground, body, new Vec2(0.0f, 8.5f), axis);
        jd.motorSpeed = 0.0f;
        jd.maxMotorForce = 100.0f;
        jd.enableMotor = true;
        jd.lowerTranslation = -4.0f;
        jd.upperTranslation = 4.0f;
        jd.enableLimit = true;
        this.getWorld().createJoint(jd);
    }

    @Override
    public String getTestName() {
        return "Line Joint";
    }
}

