/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.serialization.pb;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.box2d.proto.Box2D;
import org.jbox2d.collision.shapes.ChainShape;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.ConstantVolumeJointDef;
import org.jbox2d.dynamics.joints.DistanceJoint;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.FrictionJointDef;
import org.jbox2d.dynamics.joints.GearJointDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.MouseJointDef;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.dynamics.joints.PulleyJointDef;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.dynamics.joints.RopeJointDef;
import org.jbox2d.dynamics.joints.WeldJointDef;
import org.jbox2d.dynamics.joints.WheelJointDef;
import org.jbox2d.serialization.JbDeserializer;
import org.jbox2d.serialization.UnsupportedListener;
import org.jbox2d.serialization.UnsupportedObjectException;

public class PbDeserializer
implements JbDeserializer {
    private JbDeserializer.ObjectListener listener = null;
    private UnsupportedListener ulistener = null;

    public PbDeserializer() {
    }

    public PbDeserializer(UnsupportedListener argListener) {
        this.ulistener = argListener;
    }

    public PbDeserializer(JbDeserializer.ObjectListener argObjectListner) {
        this.listener = argObjectListner;
    }

    public PbDeserializer(UnsupportedListener argListener, JbDeserializer.ObjectListener argObjectListner) {
        this.ulistener = argListener;
        this.listener = argObjectListner;
    }

    @Override
    public void setObjectListener(JbDeserializer.ObjectListener argListener) {
        this.listener = argListener;
    }

    @Override
    public void setUnsupportedListener(UnsupportedListener argListener) {
        this.ulistener = argListener;
    }

    private boolean isIndependentJoint(Box2D.PbJointType argType) {
        return argType != Box2D.PbJointType.GEAR && argType != Box2D.PbJointType.CONSTANT_VOLUME;
    }

    @Override
    public World deserializeWorld(InputStream argInput) throws IOException {
        Box2D.PbWorld world = Box2D.PbWorld.parseFrom((InputStream)argInput);
        return this.deserializeWorld(world);
    }

    public World deserializeWorld(Box2D.PbWorld pbWorld) {
        Joint joint;
        Box2D.PbJoint pbJoint;
        World world = new World(this.pbToVec(pbWorld.getGravity()));
        world.setAutoClearForces(pbWorld.getAutoClearForces());
        world.setContinuousPhysics(pbWorld.getContinuousPhysics());
        world.setWarmStarting(pbWorld.getWarmStarting());
        world.setSubStepping(pbWorld.getSubStepping());
        HashMap<Integer, Body> bodyMap = new HashMap<Integer, Body>();
        HashMap<Integer, Joint> jointMap = new HashMap<Integer, Joint>();
        int i = 0;
        while (i < pbWorld.getBodiesCount()) {
            Box2D.PbBody pbBody = pbWorld.getBodies(i);
            Body body = this.deserializeBody(world, pbBody);
            bodyMap.put(i, body);
            ++i;
        }
        int cnt = 0;
        int i2 = 0;
        while (i2 < pbWorld.getJointsCount()) {
            pbJoint = pbWorld.getJoints(i2);
            if (this.isIndependentJoint(pbJoint.getType())) {
                joint = this.deserializeJoint(world, pbJoint, bodyMap, jointMap);
                jointMap.put(cnt, joint);
                ++cnt;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < pbWorld.getJointsCount()) {
            pbJoint = pbWorld.getJoints(i2);
            if (!this.isIndependentJoint(pbJoint.getType())) {
                joint = this.deserializeJoint(world, pbJoint, bodyMap, jointMap);
                jointMap.put(cnt, joint);
                ++cnt;
            }
            ++i2;
        }
        if (this.listener != null && pbWorld.hasTag()) {
            this.listener.processWorld(world, pbWorld.getTag());
        }
        return world;
    }

    @Override
    public Body deserializeBody(World argWorld, InputStream argInput) throws IOException {
        Box2D.PbBody body = Box2D.PbBody.parseFrom((InputStream)argInput);
        return this.deserializeBody(argWorld, body);
    }

    public Body deserializeBody(World argWorld, Box2D.PbBody argBody) {
        Box2D.PbBody b = argBody;
        BodyDef bd = new BodyDef();
        bd.position.set(this.pbToVec(b.getPosition()));
        bd.angle = b.getAngle();
        bd.linearDamping = b.getLinearDamping();
        bd.angularDamping = b.getAngularDamping();
        bd.gravityScale = b.getGravityScale();
        bd.bullet = b.getBullet();
        bd.allowSleep = b.getAllowSleep();
        bd.awake = b.getAwake();
        bd.active = b.getActive();
        bd.fixedRotation = b.getFixedRotation();
        switch (b.getType()) {
            case DYNAMIC: {
                bd.type = BodyType.DYNAMIC;
                break;
            }
            case KINEMATIC: {
                bd.type = BodyType.KINEMATIC;
                break;
            }
            case STATIC: {
                bd.type = BodyType.STATIC;
                break;
            }
            default: {
                UnsupportedObjectException e = new UnsupportedObjectException("Unknown body type: " + argBody.getType(), UnsupportedObjectException.Type.BODY);
                if (this.ulistener == null || this.ulistener.isUnsupported(e)) {
                    throw e;
                }
                return null;
            }
        }
        Body body = argWorld.createBody(bd);
        int i = 0;
        while (i < b.getFixturesCount()) {
            this.deserializeFixture(body, b.getFixtures(i));
            ++i;
        }
        body.m_linearVelocity.set(this.pbToVec(b.getLinearVelocity()));
        body.m_angularVelocity = b.getAngularVelocity();
        if (this.listener != null && b.hasTag()) {
            this.listener.processBody(body, b.getTag());
        }
        return body;
    }

    @Override
    public Fixture deserializeFixture(Body argBody, InputStream argInput) throws IOException {
        Box2D.PbFixture fixture = Box2D.PbFixture.parseFrom((InputStream)argInput);
        return this.deserializeFixture(argBody, fixture);
    }

    public Fixture deserializeFixture(Body argBody, Box2D.PbFixture argFixture) {
        Box2D.PbFixture f = argFixture;
        FixtureDef fd = new FixtureDef();
        fd.density = f.getDensity();
        fd.filter.categoryBits = f.getFilter().getCategoryBits();
        fd.filter.groupIndex = f.getFilter().getGroupIndex();
        fd.filter.maskBits = f.getFilter().getMaskBits();
        fd.friction = f.getFriction();
        fd.isSensor = f.getSensor();
        fd.restitution = f.getRestitution();
        fd.shape = this.deserializeShape(f.getShape());
        Fixture fixture = argBody.createFixture(fd);
        if (this.listener != null && f.hasTag()) {
            this.listener.processFixture(fixture, f.getTag());
        }
        return fixture;
    }

    @Override
    public Shape deserializeShape(InputStream argInput) throws IOException {
        Box2D.PbShape s = Box2D.PbShape.parseFrom((InputStream)argInput);
        return this.deserializeShape(s);
    }

    public Shape deserializeShape(Box2D.PbShape argShape) {
        Box2D.PbShape s = argShape;
        Shape shape = null;
        switch (s.getType()) {
            case CIRCLE: {
                CircleShape c = new CircleShape();
                c.m_p.set(this.pbToVec(s.getCenter()));
                shape = c;
                break;
            }
            case POLYGON: {
                PolygonShape p = new PolygonShape();
                p.m_centroid.set(this.pbToVec(s.getCentroid()));
                p.m_count = s.getPointsCount();
                int i = 0;
                while (i < p.m_count) {
                    p.m_vertices[i].set(this.pbToVec(s.getPoints(i)));
                    p.m_normals[i].set(this.pbToVec(s.getNormals(i)));
                    ++i;
                }
                shape = p;
                break;
            }
            case EDGE: {
                EdgeShape edge = new EdgeShape();
                edge.m_vertex0.set(this.pbToVec(s.getV0()));
                edge.m_vertex1.set(this.pbToVec(s.getV1()));
                edge.m_vertex2.set(this.pbToVec(s.getV2()));
                edge.m_vertex3.set(this.pbToVec(s.getV3()));
                edge.m_hasVertex0 = s.getHas0();
                edge.m_hasVertex3 = s.getHas3();
                shape = edge;
                break;
            }
            case CHAIN: {
                ChainShape chain = new ChainShape();
                chain.m_count = s.getPointsCount();
                chain.m_vertices = new Vec2[chain.m_count];
                int i = 0;
                while (i < chain.m_count) {
                    chain.m_vertices[i] = new Vec2(this.pbToVec(s.getPoints(i)));
                    ++i;
                }
                chain.m_hasPrevVertex = s.getHas0();
                chain.m_hasNextVertex = s.getHas3();
                chain.m_prevVertex.set(this.pbToVec(s.getPrev()));
                chain.m_nextVertex.set(this.pbToVec(s.getNext()));
                shape = chain;
                break;
            }
            default: {
                UnsupportedObjectException e = new UnsupportedObjectException("Unknown shape type: " + s.getType(), UnsupportedObjectException.Type.SHAPE);
                if (this.ulistener == null || this.ulistener.isUnsupported(e)) {
                    throw e;
                }
                return null;
            }
        }
        shape.m_radius = s.getRadius();
        if (this.listener != null && s.hasTag()) {
            this.listener.processShape(shape, s.getTag());
        }
        return shape;
    }

    @Override
    public Joint deserializeJoint(World argWorld, InputStream argInput, Map<Integer, Body> argBodyMap, Map<Integer, Joint> jointMap) throws IOException {
        Box2D.PbJoint joint = Box2D.PbJoint.parseFrom((InputStream)argInput);
        return this.deserializeJoint(argWorld, joint, argBodyMap, jointMap);
    }

    public Joint deserializeJoint(World argWorld, Box2D.PbJoint joint, Map<Integer, Body> argBodyMap, Map<Integer, Joint> jointMap) {
        JointDef jd = null;
        switch (joint.getType()) {
            case PRISMATIC: {
                JointDef def = new PrismaticJointDef();
                jd = def;
                ((PrismaticJointDef)def).enableLimit = joint.getEnableLimit();
                ((PrismaticJointDef)def).enableMotor = joint.getEnableMotor();
                ((PrismaticJointDef)def).localAnchorA.set(this.pbToVec(joint.getLocalAnchorA()));
                ((PrismaticJointDef)def).localAnchorB.set(this.pbToVec(joint.getLocalAnchorB()));
                ((PrismaticJointDef)def).localAxisA.set(this.pbToVec(joint.getLocalAxisA()));
                ((PrismaticJointDef)def).lowerTranslation = joint.getLowerLimit();
                ((PrismaticJointDef)def).maxMotorForce = joint.getMaxMotorForce();
                ((PrismaticJointDef)def).motorSpeed = joint.getMotorSpeed();
                ((PrismaticJointDef)def).referenceAngle = joint.getRefAngle();
                ((PrismaticJointDef)def).upperTranslation = joint.getUpperLimit();
                break;
            }
            case REVOLUTE: {
                JointDef def = new RevoluteJointDef();
                jd = def;
                ((RevoluteJointDef)def).enableLimit = joint.getEnableLimit();
                ((RevoluteJointDef)def).enableMotor = joint.getEnableMotor();
                ((RevoluteJointDef)def).localAnchorA.set(this.pbToVec(joint.getLocalAnchorA()));
                ((RevoluteJointDef)def).localAnchorB.set(this.pbToVec(joint.getLocalAnchorB()));
                ((RevoluteJointDef)def).lowerAngle = joint.getLowerLimit();
                ((RevoluteJointDef)def).maxMotorTorque = joint.getMaxMotorTorque();
                ((RevoluteJointDef)def).motorSpeed = joint.getMotorSpeed();
                ((RevoluteJointDef)def).referenceAngle = joint.getRefAngle();
                ((RevoluteJointDef)def).upperAngle = joint.getUpperLimit();
                break;
            }
            case DISTANCE: {
                JointDef def = new DistanceJointDef();
                jd = def;
                ((DistanceJointDef)def).localAnchorA.set(this.pbToVec(joint.getLocalAnchorA()));
                ((DistanceJointDef)def).localAnchorB.set(this.pbToVec(joint.getLocalAnchorB()));
                ((DistanceJointDef)def).dampingRatio = joint.getDampingRatio();
                ((DistanceJointDef)def).frequencyHz = joint.getFrequency();
                ((DistanceJointDef)def).length = joint.getLength();
                break;
            }
            case PULLEY: {
                JointDef def = new PulleyJointDef();
                jd = def;
                ((PulleyJointDef)def).localAnchorA.set(this.pbToVec(joint.getLocalAnchorA()));
                ((PulleyJointDef)def).localAnchorB.set(this.pbToVec(joint.getLocalAnchorB()));
                ((PulleyJointDef)def).groundAnchorA.set(this.pbToVec(joint.getGroundAnchorA()));
                ((PulleyJointDef)def).groundAnchorB.set(this.pbToVec(joint.getGroundAnchorB()));
                ((PulleyJointDef)def).lengthA = joint.getLengthA();
                ((PulleyJointDef)def).lengthB = joint.getLengthB();
                ((PulleyJointDef)def).ratio = joint.getRatio();
                break;
            }
            case MOUSE: {
                JointDef def = new MouseJointDef();
                jd = def;
                ((MouseJointDef)def).dampingRatio = joint.getDampingRatio();
                ((MouseJointDef)def).frequencyHz = joint.getFrequency();
                ((MouseJointDef)def).maxForce = joint.getMaxForce();
                ((MouseJointDef)def).target.set(this.pbToVec(joint.getTarget()));
                break;
            }
            case GEAR: {
                JointDef def = new GearJointDef();
                jd = def;
                if (!jointMap.containsKey(joint.getJoint1())) {
                    throw new IllegalArgumentException("Index " + joint.getJoint1() + " is not present in the joint map.");
                }
                ((GearJointDef)def).joint1 = jointMap.get(joint.getJoint1());
                if (!jointMap.containsKey(joint.getJoint2())) {
                    throw new IllegalArgumentException("Index " + joint.getJoint2() + " is not present in the joint map.");
                }
                ((GearJointDef)def).joint2 = jointMap.get(joint.getJoint2());
                ((GearJointDef)def).ratio = joint.getRatio();
                break;
            }
            case WHEEL: {
                JointDef def = new WheelJointDef();
                jd = def;
                ((WheelJointDef)def).localAnchorA.set(this.pbToVec(joint.getLocalAnchorA()));
                ((WheelJointDef)def).localAnchorB.set(this.pbToVec(joint.getLocalAnchorB()));
                ((WheelJointDef)def).localAxisA.set(this.pbToVec(joint.getLocalAxisA()));
                ((WheelJointDef)def).enableMotor = joint.getEnableMotor();
                ((WheelJointDef)def).maxMotorTorque = joint.getMaxMotorTorque();
                ((WheelJointDef)def).motorSpeed = joint.getMotorSpeed();
                ((WheelJointDef)def).frequencyHz = joint.getFrequency();
                ((WheelJointDef)def).dampingRatio = joint.getDampingRatio();
                break;
            }
            case WELD: {
                JointDef def = new WeldJointDef();
                jd = def;
                ((WeldJointDef)def).localAnchorA.set(this.pbToVec(joint.getLocalAnchorA()));
                ((WeldJointDef)def).localAnchorB.set(this.pbToVec(joint.getLocalAnchorB()));
                ((WeldJointDef)def).referenceAngle = joint.getRefAngle();
                ((WeldJointDef)def).frequencyHz = joint.getFrequency();
                ((WeldJointDef)def).dampingRatio = joint.getDampingRatio();
                break;
            }
            case FRICTION: {
                JointDef def = new FrictionJointDef();
                jd = def;
                ((FrictionJointDef)def).localAnchorA.set(this.pbToVec(joint.getLocalAnchorA()));
                ((FrictionJointDef)def).localAnchorB.set(this.pbToVec(joint.getLocalAnchorB()));
                ((FrictionJointDef)def).maxForce = joint.getMaxForce();
                ((FrictionJointDef)def).maxTorque = joint.getMaxTorque();
                break;
            }
            case ROPE: {
                RopeJointDef def = new RopeJointDef();
                jd = def;
                def.localAnchorA.set(this.pbToVec(joint.getLocalAnchorA()));
                def.localAnchorB.set(this.pbToVec(joint.getLocalAnchorB()));
                def.maxLength = joint.getMaxLength();
                return null;
            }
            case CONSTANT_VOLUME: {
                JointDef def = new ConstantVolumeJointDef();
                jd = def;
                ((ConstantVolumeJointDef)def).dampingRatio = joint.getDampingRatio();
                ((ConstantVolumeJointDef)def).frequencyHz = joint.getFrequency();
                if (joint.getBodiesCount() != joint.getJointsCount()) {
                    throw new IllegalArgumentException("Constant volume joint must have bodies and joints defined");
                }
                int i = 0;
                while (i < joint.getBodiesCount()) {
                    int body = joint.getBodies(i);
                    if (!argBodyMap.containsKey(body)) {
                        throw new IllegalArgumentException("Index " + body + " is not present in the body map");
                    }
                    int jointIndex = joint.getJoints(i);
                    if (!jointMap.containsKey(jointIndex)) {
                        throw new IllegalArgumentException("Index " + jointIndex + " is not present in the joint map");
                    }
                    Joint djoint = jointMap.get(jointIndex);
                    if (!(djoint instanceof DistanceJoint)) {
                        throw new IllegalArgumentException("Joints for constant volume joint must be distance joints");
                    }
                    ((ConstantVolumeJointDef)def).addBodyAndJoint(argBodyMap.get(body), (DistanceJoint)djoint);
                    ++i;
                }
                break;
            }
            case LINE: {
                UnsupportedObjectException e = new UnsupportedObjectException("Line joint no longer supported.", UnsupportedObjectException.Type.JOINT);
                if (this.ulistener == null || this.ulistener.isUnsupported(e)) {
                    throw e;
                }
                return null;
            }
            default: {
                UnsupportedObjectException e = new UnsupportedObjectException("Unknown joint type: " + joint.getType(), UnsupportedObjectException.Type.JOINT);
                if (this.ulistener == null || this.ulistener.isUnsupported(e)) {
                    throw e;
                }
                return null;
            }
        }
        jd.collideConnected = joint.getCollideConnected();
        if (!argBodyMap.containsKey(joint.getBodyA())) {
            throw new IllegalArgumentException("Index " + joint.getBodyA() + " is not present in the body map");
        }
        jd.bodyA = argBodyMap.get(joint.getBodyA());
        if (!argBodyMap.containsKey(joint.getBodyB())) {
            throw new IllegalArgumentException("Index " + joint.getBodyB() + " is not present in the body map");
        }
        jd.bodyB = argBodyMap.get(joint.getBodyB());
        Joint realJoint = argWorld.createJoint(jd);
        if (this.listener != null && joint.hasTag()) {
            this.listener.processJoint(realJoint, joint.getTag());
        }
        return realJoint;
    }

    private Vec2 pbToVec(Box2D.PbVec2 argVec) {
        return new Vec2(argVec.getX(), argVec.getY());
    }
}

