/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.pooling.normal;

import java.lang.reflect.Array;
import org.jbox2d.pooling.IOrderedStack;

public class CircleStack<E>
implements IOrderedStack<E> {
    private final E[] pool;
    private int index;
    private final int size;
    private final E[] container;

    public CircleStack(Class<E> argClass, int argStackSize, int argContainerSize) {
        this.size = argStackSize;
        this.pool = (Object[])Array.newInstance(argClass, argStackSize);
        int i = 0;
        while (i < argStackSize) {
            try {
                this.pool[i] = argClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating pooled object " + argClass.getSimpleName(), e);
            }
            ++i;
        }
        this.index = 0;
        this.container = (Object[])Array.newInstance(argClass, argContainerSize);
    }

    @Override
    public final E pop() {
        ++this.index;
        if (this.index >= this.size) {
            this.index = 0;
        }
        return this.pool[this.index];
    }

    @Override
    public final E[] pop(int argNum) {
        assert (argNum <= this.container.length) : "Container array is too small";
        if (this.index + argNum < this.size) {
            System.arraycopy(this.pool, this.index, this.container, 0, argNum);
            this.index += argNum;
        } else {
            int overlap = this.index + argNum - this.size;
            System.arraycopy(this.pool, this.index, this.container, 0, argNum - overlap);
            System.arraycopy(this.pool, 0, this.container, argNum - overlap, overlap);
            this.index = overlap;
        }
        return this.container;
    }

    @Override
    public void push(int argNum) {
    }
}

