/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.common.Vec2;

public class Manifold {
    public final ManifoldPoint[] points = new ManifoldPoint[2];
    public final Vec2 localNormal;
    public final Vec2 localPoint;
    public ManifoldType type;
    public int pointCount;

    public Manifold() {
        int i = 0;
        while (i < 2) {
            this.points[i] = new ManifoldPoint();
            ++i;
        }
        this.localNormal = new Vec2();
        this.localPoint = new Vec2();
        this.pointCount = 0;
    }

    public Manifold(Manifold other) {
        this.localNormal = other.localNormal.clone();
        this.localPoint = other.localPoint.clone();
        this.pointCount = other.pointCount;
        this.type = other.type;
        int i = 0;
        while (i < 2) {
            this.points[i] = new ManifoldPoint(other.points[i]);
            ++i;
        }
    }

    public void set(Manifold cp) {
        int i = 0;
        while (i < cp.pointCount) {
            this.points[i].set(cp.points[i]);
            ++i;
        }
        this.type = cp.type;
        this.localNormal.set(cp.localNormal);
        this.localPoint.set(cp.localPoint);
        this.pointCount = cp.pointCount;
    }

    public static enum ManifoldType {
        CIRCLES,
        FACE_A,
        FACE_B;

    }
}

