/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.PulleyJoint;
import org.jbox2d.dynamics.joints.PulleyJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class Pulleys
extends TestbedTest {
    PulleyJoint m_joint1;

    @Override
    public void initTest(boolean argDeserialized) {
        float y = 16.0f;
        float L = 12.0f;
        float a = 1.0f;
        float b = 2.0f;
        Body ground = null;
        BodyDef bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        ground.createFixture(shape, 0.0f);
        CircleShape circle = new CircleShape();
        circle.m_radius = 2.0f;
        circle.m_p.set(-10.0f, y + b + L);
        ground.createFixture(circle, 0.0f);
        circle.m_p.set(10.0f, y + b + L);
        ground.createFixture(circle, 0.0f);
        PolygonShape shape2 = new PolygonShape();
        shape2.setAsBox(a, b);
        BodyDef bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        bd2.position.set(-10.0f, y);
        Body body1 = this.getWorld().createBody(bd2);
        body1.createFixture(shape2, 5.0f);
        bd2.position.set(10.0f, y);
        Body body2 = this.getWorld().createBody(bd2);
        body2.createFixture(shape2, 5.0f);
        PulleyJointDef pulleyDef = new PulleyJointDef();
        Vec2 anchor1 = new Vec2(-10.0f, y + b);
        Vec2 anchor2 = new Vec2(10.0f, y + b);
        Vec2 groundAnchor1 = new Vec2(-10.0f, y + b + L);
        Vec2 groundAnchor2 = new Vec2(10.0f, y + b + L);
        pulleyDef.initialize(body1, body2, groundAnchor1, groundAnchor2, anchor1, anchor2, 2.0f);
        this.m_joint1 = (PulleyJoint)this.getWorld().createJoint(pulleyDef);
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        float ratio = this.m_joint1.getRatio();
        float L = this.m_joint1.getLength1() + ratio * this.m_joint1.getLength2();
        this.addTextLine("L1 + " + ratio + " * L2 = " + L);
        if (L >= 36.0f) {
            this.addTextLine("Pulley is taught");
        }
    }

    @Override
    public String getTestName() {
        return "Pulleys";
    }
}

