/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.iforce2d.Jb2dJson;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class LoadRUBE_customProperties
extends TestbedTest {
    Map<Body, WobblyProperties> m_wobblyBodyPropertiesMap;
    float m_timePassed;

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean argDeserialized) {
        if (argDeserialized) {
            return;
        }
        this.m_wobblyBodyPropertiesMap = new HashMap<Body, WobblyProperties>();
        Jb2dJson json = new Jb2dJson();
        StringBuilder errorMsg = new StringBuilder();
        World world = json.readFromFile("customProperties.json", errorMsg);
        if (null != world) {
            this.m_world = world;
            this.groundBody = this.m_world.createBody(new BodyDef());
            this.m_world.setDestructionListener(this.destructionListener);
            this.m_world.setContactListener(this);
            this.m_world.setDebugDraw(this.model.getDebugDraw());
            Vector<Body> wobblyBodies = new Vector<Body>();
            json.getBodiesByCustomString("category", "wobbly", wobblyBodies);
            for (int i = 0; i < wobblyBodies.size(); ++i) {
                Body b = wobblyBodies.elementAt(i);
                WobblyProperties wp = new WobblyProperties();
                wp.basePos = new Vec2(b.getPosition());
                wp.horizontalRange = json.getCustomFloat(b, "horzRange", 0.0f);
                wp.verticalRange = json.getCustomFloat(b, "vertRange", 0.0f);
                wp.speed = json.getCustomFloat(b, "speed", 0.0f);
                this.m_wobblyBodyPropertiesMap.put(b, wp);
            }
        } else {
            System.out.println(errorMsg);
        }
        this.m_timePassed = 0.0f;
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("The movement of these bodies is defined by custom properties.");
        float hz = settings.getSetting((String)"Hz").value;
        this.m_timePassed += 1.0f / hz;
        for (Map.Entry<Body, WobblyProperties> pair : this.m_wobblyBodyPropertiesMap.entrySet()) {
            Body b = pair.getKey();
            WobblyProperties wp = pair.getValue();
            Vec2 pos = wp.basePos.add(new Vec2((float)Math.sin(this.m_timePassed * wp.speed) * wp.horizontalRange, (float)Math.cos(this.m_timePassed * wp.speed) * wp.verticalRange));
            b.setTransform(pos, 0.0f);
        }
    }

    @Override
    public String getTestName() {
        return "Load RUBE - custom properties";
    }

    class WobblyProperties {
        Vec2 basePos;
        float horizontalRange;
        float verticalRange;
        float speed;

        WobblyProperties() {
        }
    }
}

