/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class ConvexHull
extends TestbedTest {
    private final int count = 8;
    private boolean m_auto = false;
    private Vec2[] m_points = new Vec2[8];
    PolygonShape shape = new PolygonShape();
    Color3f color = new Color3f(0.9f, 0.9f, 0.9f);
    Color3f color2 = new Color3f(0.9f, 0.5f, 0.5f);

    @Override
    public void initTest(boolean deserialized) {
        this.generate();
    }

    void generate() {
        Vec2 lowerBound = new Vec2(-8.0f, -8.0f);
        Vec2 upperBound = new Vec2(8.0f, 8.0f);
        for (int i = 0; i < 8; ++i) {
            float x = MathUtils.randomFloat(0.0f, 10.0f);
            float y = MathUtils.randomFloat(0.0f, 10.0f);
            Vec2 v = new Vec2(x, y);
            MathUtils.clampToOut(v, lowerBound, upperBound, v);
            this.m_points[i] = v;
        }
    }

    @Override
    public void keyPressed(char argKeyChar, int argKeyCode) {
        if (argKeyChar == 'g') {
            this.generate();
        } else if (argKeyChar == 'a') {
            this.m_auto = !this.m_auto;
        }
    }

    @Override
    public synchronized void step(TestbedSettings settings) {
        super.step(settings);
        this.shape.set(this.m_points, 8);
        this.addTextLine("Press g to generate a new random convex hull");
        this.getDebugDraw().drawPolygon(this.shape.m_vertices, this.shape.m_count, this.color);
        for (int i = 0; i < 8; ++i) {
            this.getDebugDraw().drawPoint(this.m_points[i], 2.0f, this.color2);
            this.getDebugDraw().drawString(this.m_points[i].add(new Vec2(0.05f, 0.05f)), i + "", Color3f.WHITE);
        }
        assert (this.shape.validate());
        if (this.m_auto) {
            this.generate();
        }
    }

    @Override
    public String getTestName() {
        return "Convex Hull";
    }
}

