/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import java.util.HashSet;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.testbed.framework.ContactPoint;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class CollisionProcessing
extends TestbedTest {
    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean argDeserialized) {
        if (argDeserialized) {
            return;
        }
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-50.0f, 0.0f), new Vec2(50.0f, 0.0f));
        FixtureDef sd = new FixtureDef();
        sd.shape = shape;
        BodyDef bd = new BodyDef();
        Body ground = this.getWorld().createBody(bd);
        ground.createFixture(sd);
        float xLo = -5.0f;
        float xHi = 5.0f;
        float yLo = 2.0f;
        float yHi = 35.0f;
        Vec2[] vertices = new Vec2[]{new Vec2(-1.0f, 0.0f), new Vec2(1.0f, 0.0f), new Vec2(0.0f, 2.0f)};
        PolygonShape polygon = new PolygonShape();
        polygon.set(vertices, 3);
        FixtureDef triangleShapeDef = new FixtureDef();
        triangleShapeDef.shape = polygon;
        triangleShapeDef.density = 1.0f;
        BodyDef triangleBodyDef = new BodyDef();
        triangleBodyDef.type = BodyType.DYNAMIC;
        triangleBodyDef.position.set(MathUtils.randomFloat(xLo, xHi), MathUtils.randomFloat(yLo, yHi));
        Body body1 = this.getWorld().createBody(triangleBodyDef);
        body1.createFixture(triangleShapeDef);
        vertices[0].mulLocal(2.0f);
        vertices[1].mulLocal(2.0f);
        vertices[2].mulLocal(2.0f);
        polygon.set(vertices, 3);
        triangleBodyDef.position.set(MathUtils.randomFloat(xLo, xHi), MathUtils.randomFloat(yLo, yHi));
        Body body2 = this.getWorld().createBody(triangleBodyDef);
        body2.createFixture(triangleShapeDef);
        polygon.setAsBox(1.0f, 0.5f);
        FixtureDef boxShapeDef = new FixtureDef();
        boxShapeDef.shape = polygon;
        boxShapeDef.density = 1.0f;
        BodyDef boxBodyDef = new BodyDef();
        boxBodyDef.type = BodyType.DYNAMIC;
        boxBodyDef.position.set(MathUtils.randomFloat(xLo, xHi), MathUtils.randomFloat(yLo, yHi));
        Body body3 = this.getWorld().createBody(boxBodyDef);
        body3.createFixture(boxShapeDef);
        polygon.setAsBox(2.0f, 1.0f);
        boxBodyDef.position.set(MathUtils.randomFloat(xLo, xHi), MathUtils.randomFloat(yLo, yHi));
        Body body4 = this.getWorld().createBody(boxBodyDef);
        body4.createFixture(boxShapeDef);
        CircleShape circle = new CircleShape();
        circle.m_radius = 1.0f;
        FixtureDef circleShapeDef = new FixtureDef();
        circleShapeDef.shape = circle;
        circleShapeDef.density = 1.0f;
        BodyDef circleBodyDef = new BodyDef();
        circleBodyDef.type = BodyType.DYNAMIC;
        circleBodyDef.position.set(MathUtils.randomFloat(xLo, xHi), MathUtils.randomFloat(yLo, yHi));
        Body body5 = this.getWorld().createBody(circleBodyDef);
        body5.createFixture(circleShapeDef);
        circle.m_radius *= 2.0f;
        circleBodyDef.position.set(MathUtils.randomFloat(xLo, xHi), MathUtils.randomFloat(yLo, yHi));
        Body body6 = this.getWorld().createBody(circleBodyDef);
        body6.createFixture(circleShapeDef);
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        HashSet<Body> nuke = new HashSet<Body>();
        for (int i = 0; i < this.getPointCount(); ++i) {
            ContactPoint point = points[i];
            Body body1 = point.fixtureA.getBody();
            Body body2 = point.fixtureB.getBody();
            float mass1 = body1.getMass();
            float mass2 = body2.getMass();
            if (!(mass1 > 0.0f) || !(mass2 > 0.0f)) continue;
            if (mass2 > mass1) {
                nuke.add(body1);
                continue;
            }
            nuke.add(body2);
        }
        for (Body b : nuke) {
            if (b == this.getBomb()) continue;
            this.getWorld().destroyBody(b);
        }
    }

    @Override
    public String getTestName() {
        return "Collision Processing";
    }
}

