/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class BodyTypes
extends TestbedTest {
    Body m_attachment;
    Body m_platform;
    float m_speed;

    @Override
    public void initTest(boolean argDeserialized) {
        this.m_speed = 3.0f;
        if (argDeserialized) {
            return;
        }
        Body ground = null;
        BodyDef bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        Shape shape = new EdgeShape();
        ((EdgeShape)shape).set(new Vec2(-20.0f, 0.0f), new Vec2(20.0f, 0.0f));
        FixtureDef fd = new FixtureDef();
        fd.shape = shape;
        ground.createFixture(fd);
        bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.position.set(0.0f, 3.0f);
        this.m_attachment = this.getWorld().createBody(bd);
        shape = new PolygonShape();
        ((PolygonShape)shape).setAsBox(0.5f, 2.0f);
        this.m_attachment.createFixture(shape, 2.0f);
        bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.position.set(-4.0f, 5.0f);
        this.m_platform = this.getWorld().createBody(bd);
        shape = new PolygonShape();
        ((PolygonShape)shape).setAsBox(0.5f, 4.0f, new Vec2(4.0f, 0.0f), 1.5707964f);
        fd = new FixtureDef();
        fd.shape = shape;
        fd.friction = 0.6f;
        fd.density = 2.0f;
        this.m_platform.createFixture(fd);
        RevoluteJointDef rjd = new RevoluteJointDef();
        rjd.initialize(this.m_attachment, this.m_platform, new Vec2(0.0f, 5.0f));
        rjd.maxMotorTorque = 50.0f;
        rjd.enableMotor = true;
        this.getWorld().createJoint(rjd);
        PrismaticJointDef pjd = new PrismaticJointDef();
        pjd.initialize(ground, this.m_platform, new Vec2(0.0f, 5.0f), new Vec2(1.0f, 0.0f));
        pjd.maxMotorForce = 1000.0f;
        pjd.enableMotor = true;
        pjd.lowerTranslation = -10.0f;
        pjd.upperTranslation = 10.0f;
        pjd.enableLimit = true;
        this.getWorld().createJoint(pjd);
        bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.position.set(0.0f, 8.0f);
        Body body = this.getWorld().createBody(bd);
        PolygonShape shape2 = new PolygonShape();
        shape2.setAsBox(0.75f, 0.75f);
        FixtureDef fd2 = new FixtureDef();
        fd2.shape = shape2;
        fd2.friction = 0.6f;
        fd2.density = 2.0f;
        body.createFixture(fd2);
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("Keys: (d) dynamic, (s) static, (k) kinematic");
        if (this.m_platform.getType() == BodyType.KINEMATIC) {
            Vec2 p = this.m_platform.getTransform().p;
            Vec2 v = this.m_platform.getLinearVelocity();
            if (p.x < -10.0f && v.x < 0.0f || p.x > 10.0f && v.x > 0.0f) {
                v.x = -v.x;
                this.m_platform.setLinearVelocity(v);
            }
        }
    }

    @Override
    public void keyPressed(char argKeyChar, int argKeyCode) {
        switch (argKeyChar) {
            case 'd': {
                this.m_platform.setType(BodyType.DYNAMIC);
                break;
            }
            case 's': {
                this.m_platform.setType(BodyType.STATIC);
                break;
            }
            case 'k': {
                this.m_platform.setType(BodyType.KINEMATIC);
                this.m_platform.setLinearVelocity(new Vec2(-this.m_speed, 0.0f));
                this.m_platform.setAngularVelocity(0.0f);
            }
        }
    }

    @Override
    public String getTestName() {
        return "Body Types";
    }
}

