/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.perf;

public abstract class PerfTest {
    private final int numTests;
    private final int iters;
    private final long[] times;

    public PerfTest(int argNumTests, int argIters) {
        this.numTests = argNumTests;
        this.iters = argIters;
        this.times = new long[this.numTests];
        for (int i = 0; i < this.numTests; ++i) {
            this.times[i] = 0L;
        }
    }

    public double getTestTime(int testNum) {
        return (double)this.times[testNum] * 1.0 / 1000000.0;
    }

    public void go() {
        for (int i = 0; i < this.iters; ++i) {
            System.out.println((double)i * 100.0 / (double)this.iters + "%");
            int test = 0;
            while (test < this.numTests) {
                long prev = System.nanoTime();
                this.runTest(test);
                long after = System.nanoTime();
                int n = test++;
                this.times[n] = this.times[n] + (after - prev);
            }
        }
        int test = 0;
        while (test < this.numTests) {
            int n = test++;
            this.times[n] = this.times[n] / (long)this.iters;
        }
        this.printResults();
    }

    public void printResults() {
        System.out.printf("%-20s%20s%20s\n", "Test Name", "Milliseconds Avg", "FPS (optional)");
        for (int i = 0; i < this.numTests; ++i) {
            double milliseconds = (double)this.times[i] * 1.0 / 1000000.0;
            if (this.getFrames(i) != 0) {
                double fps = (double)this.getFrames(i) * 1000.0 / milliseconds;
                System.out.printf("%-20s%20.4f%20.4f\n", this.getTestName(i), milliseconds, fps);
                continue;
            }
            System.out.printf("%-20s%20.4f\n", this.getTestName(i), milliseconds);
        }
    }

    public abstract void runTest(int var1);

    public abstract String getTestName(int var1);

    public int getFrames(int testNum) {
        return 0;
    }
}

