/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.framework.j2d;

import java.awt.AWTError;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.OBBViewportTransform;
import org.jbox2d.common.Vec2;
import org.jbox2d.testbed.framework.TestbedModel;
import org.jbox2d.testbed.framework.TestbedPanel;
import org.jbox2d.testbed.framework.TestbedTest;
import org.jbox2d.testbed.framework.j2d.DebugDrawJ2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPanelJ2D
extends JPanel
implements TestbedPanel {
    private static final Logger log = LoggerFactory.getLogger(TestPanelJ2D.class);
    public static final int INIT_WIDTH = 600;
    public static final int INIT_HEIGHT = 600;
    private static final float ZOOM_OUT_SCALE = 0.95f;
    private static final float ZOOM_IN_SCALE = 1.05f;
    private Graphics2D dbg = null;
    private Image dbImage = null;
    private int panelWidth;
    private int panelHeight;
    private final TestbedModel model;
    private final DebugDrawJ2D draw;
    private final Vec2 dragginMouse = new Vec2();
    private boolean drag = false;

    public TestPanelJ2D(TestbedModel argModel) {
        this.setBackground(Color.black);
        this.draw = new DebugDrawJ2D(this);
        this.model = argModel;
        this.updateSize(600, 600);
        this.setPreferredSize(new Dimension(600, 600));
        this.addMouseWheelListener(new MouseWheelListener(){
            private final Vec2 oldCenter = new Vec2();
            private final Vec2 newCenter = new Vec2();
            private final Mat22 upScale = Mat22.createScaleTransform(1.05f);
            private final Mat22 downScale = Mat22.createScaleTransform(0.95f);

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                DebugDrawJ2D d = TestPanelJ2D.this.draw;
                int notches = e.getWheelRotation();
                TestbedTest currTest = TestPanelJ2D.this.model.getCurrTest();
                if (currTest == null) {
                    return;
                }
                OBBViewportTransform trans = (OBBViewportTransform)d.getViewportTranform();
                this.oldCenter.set(TestPanelJ2D.this.model.getCurrTest().getWorldMouse());
                if (notches < 0) {
                    trans.mulByTransform(this.upScale);
                    currTest.setCachedCameraScale(currTest.getCachedCameraScale() * 1.05f);
                } else if (notches > 0) {
                    trans.mulByTransform(this.downScale);
                    currTest.setCachedCameraScale(currTest.getCachedCameraScale() * 0.95f);
                }
                d.getScreenToWorldToOut(TestPanelJ2D.this.model.getMouse(), this.newCenter);
                Vec2 transformedMove = this.oldCenter.subLocal(this.newCenter);
                d.getViewportTranform().setCenter(d.getViewportTranform().getCenter().addLocal(transformedMove));
                currTest.setCachedCameraPos(d.getViewportTranform().getCenter());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TestPanelJ2D.this.dragginMouse.set(e.getX(), e.getY());
                TestPanelJ2D.this.drag = e.getButton() == 3;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!TestPanelJ2D.this.drag) {
                    return;
                }
                TestbedTest currTest = TestPanelJ2D.this.model.getCurrTest();
                if (currTest == null) {
                    return;
                }
                Vec2 diff = new Vec2(e.getX(), e.getY());
                diff.subLocal(TestPanelJ2D.this.dragginMouse);
                currTest.getDebugDraw().getViewportTranform().getScreenVectorToWorld(diff, diff);
                currTest.getDebugDraw().getViewportTranform().getCenter().subLocal(diff);
                TestPanelJ2D.this.dragginMouse.set(e.getX(), e.getY());
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TestPanelJ2D.this.updateSize(TestPanelJ2D.this.getWidth(), TestPanelJ2D.this.getHeight());
                TestPanelJ2D.this.dbImage = null;
            }
        });
    }

    @Override
    public DebugDraw getDebugDraw() {
        return this.draw;
    }

    public Graphics2D getDBGraphics() {
        return this.dbg;
    }

    private void updateSize(int argWidth, int argHeight) {
        this.panelWidth = argWidth;
        this.panelHeight = argHeight;
        this.draw.getViewportTranform().setExtents(argWidth / 2, argHeight / 2);
    }

    @Override
    public boolean render() {
        if (this.dbImage == null) {
            log.debug("dbImage is null, creating a new one");
            if (this.panelWidth <= 0 || this.panelHeight <= 0) {
                return false;
            }
            this.dbImage = this.createImage(this.panelWidth, this.panelHeight);
            if (this.dbImage == null) {
                log.error("dbImage is still null, ignoring render call");
                return false;
            }
            this.dbg = (Graphics2D)this.dbImage.getGraphics();
        }
        this.dbg.setColor(Color.black);
        this.dbg.fillRect(0, 0, this.panelWidth, this.panelHeight);
        return true;
    }

    @Override
    public void paintScreen() {
        try {
            Graphics g = this.getGraphics();
            if (g != null && this.dbImage != null) {
                g.drawImage(this.dbImage, 0, 0, null);
                Toolkit.getDefaultToolkit().sync();
                g.dispose();
            }
        }
        catch (AWTError e) {
            log.error("Graphics context error", e);
        }
    }
}

