/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.pooling.normal;

import java.lang.reflect.Array;
import org.jbox2d.pooling.IDynamicStack;

public class MutableStack<E, T extends E>
implements IDynamicStack<E> {
    private T[] stack;
    private int index = 0;
    private int size;
    private final Class<T> sClass;
    private final Class<?>[] params;
    private final Object[] args;

    public MutableStack(Class<T> argClass, int argInitSize) {
        this(argClass, argInitSize, null, null);
    }

    public MutableStack(Class<T> argClass, int argInitSize, Class<?>[] argParam, Object[] argArgs) {
        this.sClass = argClass;
        this.params = argParam;
        this.args = argArgs;
        this.stack = null;
        this.index = 0;
        this.extendStack(argInitSize);
    }

    private void extendStack(int argSize) {
        Object[] newStack = (Object[])Array.newInstance(this.sClass, argSize);
        if (this.stack != null) {
            System.arraycopy(this.stack, 0, newStack, 0, this.size);
        }
        int i = 0;
        while (i < newStack.length) {
            try {
                newStack[i] = this.params != null ? this.sClass.getConstructor(this.params).newInstance(this.args) : this.sClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating pooled object " + this.sClass.getSimpleName(), e);
            }
            ++i;
        }
        this.stack = newStack;
        this.size = newStack.length;
    }

    @Override
    public final E pop() {
        if (this.index >= this.size) {
            this.extendStack(this.size * 2);
        }
        return (E)this.stack[this.index++];
    }

    @Override
    public final void push(E argObject) {
        assert (this.index > 0);
        this.stack[--this.index] = argObject;
    }
}

