/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.tests.math;

import org.jbox2d.common.MathUtils;
import org.jbox2d.tests.math.SinCosTable;

public class SinCosTest {
    public static final int COLUMN_PADDING = 3;
    public static final int NUM_DECIMALS = 8;
    public static int numTables = 50;
    public static float mostPreciseTable = 1.0E-5f;
    public static float leastPreciseTable = 0.01f;
    public static int accuracyIterations = 100000;
    public static int speedTrials = 20;
    public static int speedIterations = 50000;
    private static SinCosTable[] tables;

    public static void main(String[] args) {
        int overall = 1;
        try {
            numTables = Integer.parseInt(args[0]);
            mostPreciseTable = Float.parseFloat(args[1]);
            leastPreciseTable = Float.parseFloat(args[2]);
            accuracyIterations = Integer.parseInt(args[3]);
            speedTrials = Integer.parseInt(args[4]);
            speedIterations = Integer.parseInt(args[5]);
            overall = Integer.parseInt(args[6]);
        }
        catch (Exception e) {
            System.out.println("Parameters: <number of tables to use> <most precise table value (smallest)> <least precise table value> <number of accuracy test iterations> <number of speed test trials><number of speed test iterations> <number of overall speed test sets>");
            System.out.println("Sample parameters: 200 .00001 .01 100000 20 5000 2");
        }
        System.out.println("Tables: " + numTables);
        System.out.println("Most Precise Table: " + mostPreciseTable);
        System.out.println("Least Precise Table: " + leastPreciseTable);
        System.out.println("Accuracy Iterations: " + accuracyIterations);
        System.out.println("Speed Trials: " + speedTrials);
        System.out.println("Speed Iterations: " + speedIterations);
        SinCosTest.constructTables();
        SinCosTest.doAccuracyTest(true);
        for (int i = 0; i < overall; ++i) {
            SinCosTest.doSpeedTest(true);
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static final void constructTables() {
        tables = new SinCosTable[numTables];
        System.out.println("constructing tables");
        for (int i = 0; i < numTables; ++i) {
            float precision = (float)i * 1.0f / (float)numTables * (leastPreciseTable - mostPreciseTable) + mostPreciseTable;
            SinCosTest.tables[i] = new SinCosTable(precision);
        }
    }

    public static final double[][] doAccuracyTest(boolean print) {
        int i;
        System.out.println("doing accuracy tests");
        double[][] accuracyResults = new double[numTables][3];
        SinCosTable.LERP_LOOKUP = false;
        for (i = 0; i < numTables; ++i) {
            accuracyResults[i][0] = SinCosTest.accuracyTest(tables[i], accuracyIterations);
        }
        SinCosTable.LERP_LOOKUP = true;
        for (i = 0; i < numTables; ++i) {
            accuracyResults[i][1] = SinCosTest.accuracyTest(tables[i], accuracyIterations);
        }
        for (i = 0; i < numTables; ++i) {
            accuracyResults[i][2] = accuracyResults[i][0] - accuracyResults[i][1];
        }
        if (print) {
            System.out.println("Accuracy results, average displacement");
            String[] header = new String[]{"Not lerped", "Lerped", "Difference"};
            String[] side = new String[numTables + 1];
            side[0] = "Table precision";
            for (int i2 = 0; i2 < tables.length; ++i2) {
                side[i2 + 1] = SinCosTest.formatDecimal(SinCosTest.tables[i2].precision, 8);
            }
            SinCosTest.printTable(header, side, accuracyResults);
        }
        return accuracyResults;
    }

    public static final double[][] doSpeedTest(boolean print) {
        int i;
        System.out.println("\nDoing speed tests");
        double[][] speedResults = new double[numTables][4];
        SinCosTable.LERP_LOOKUP = false;
        for (i = 0; i < numTables; ++i) {
            speedResults[i][0] = SinCosTest.speedTest(tables[i], speedIterations, speedTrials);
        }
        SinCosTable.LERP_LOOKUP = true;
        for (i = 0; i < numTables; ++i) {
            speedResults[i][1] = SinCosTest.speedTest(tables[i], speedIterations, speedTrials);
        }
        for (i = 0; i < numTables; ++i) {
            speedResults[i][3] = SinCosTest.speedTestMath(speedIterations, speedTrials);
        }
        for (i = 0; i < numTables; ++i) {
            speedResults[i][2] = speedResults[i][0] - speedResults[i][1];
        }
        if (print) {
            System.out.println("Speed results, in iterations per second (higher number means faster)");
            String[] header = new String[]{"Not lerped", "Lerped", "Difference", "Java Math"};
            String[] side = new String[numTables + 1];
            side[0] = "Table precision";
            for (int i2 = 0; i2 < tables.length; ++i2) {
                side[i2 + 1] = SinCosTest.formatDecimal(SinCosTest.tables[i2].precision, 8);
            }
            SinCosTest.printTable(header, side, speedResults);
        }
        return speedResults;
    }

    private static double accuracyTest(SinCosTable table, int iterations) {
        double totalDiff = 0.0;
        double diff = 0.0;
        for (int i = 0; i < iterations; ++i) {
            float querry = (float)Math.random() * ((float)Math.PI * 2);
            diff = MathUtils.abs((float)Math.sin(querry) - table.sin(querry));
            totalDiff += diff;
        }
        return totalDiff /= (double)iterations;
    }

    private static void printTable(String[] header, String[] side, double[][] results) {
        int i;
        int[] colLengths = new int[results[0].length + 1];
        for (i = 0; i < colLengths.length; ++i) {
            colLengths[i] = 0;
        }
        for (int j = -1; j < results[0].length; ++j) {
            int colLength;
            if (j == -1) {
                colLength = side[j + 1].length() + 3;
                if (colLength <= colLengths[j + 1]) continue;
                colLengths[j + 1] = colLength;
                continue;
            }
            colLength = header[j].length() + 3;
            if (colLength > colLengths[j + 1]) {
                colLengths[j + 1] = colLength;
            }
            for (int i2 = 0; i2 < results.length; ++i2) {
                colLength = SinCosTest.formatDecimal(results[i2][j], 8).length() + 3;
                if (colLength <= colLengths[j + 1]) continue;
                colLengths[j + 1] = colLength;
            }
        }
        System.out.print(SinCosTest.spaceString(side[0], colLengths[0]));
        for (i = 1; i < colLengths.length; ++i) {
            System.out.print(SinCosTest.spaceString(header[i - 1], colLengths[i]));
        }
        System.out.println();
        for (i = 0; i < results.length; ++i) {
            for (int j = -1; j < results[i].length; ++j) {
                if (j == -1) {
                    System.out.print(SinCosTest.spaceString(side[i + 1], colLengths[j + 1]));
                    continue;
                }
                String toPrint = SinCosTest.formatDecimal(results[i][j], 8);
                System.out.print(SinCosTest.spaceString(toPrint, colLengths[j + 1]));
            }
            System.out.println();
        }
    }

    private static long speedTest(SinCosTable table, int numIterations, int numTrials) {
        long totalTime = 0L;
        float k = 0.0f;
        float jstep = (float)Math.PI * 2 / (float)numIterations;
        for (float i = 0.0f; i < (float)numTrials; i += 1.0f) {
            long startTime = System.nanoTime();
            for (float j = 0.0f; j < (float)Math.PI * 2; j += jstep) {
                k += table.sin(j);
            }
            long endTime = System.nanoTime();
            totalTime += endTime - startTime;
        }
        i += k;
        return (long)(numIterations * numTrials) * 1000000000L / totalTime;
    }

    private static long speedTestMath(int numIterations, int numTrials) {
        long totalTime = 0L;
        float k = 0.0f;
        float jstep = (float)Math.PI * 2 / (float)numIterations;
        for (float i = 0.0f; i < (float)numTrials; i += 1.0f) {
            long startTime = System.nanoTime();
            for (float j = 0.0f; j < (float)Math.PI * 2; j += jstep) {
                k += (float)StrictMath.sin(j);
            }
            long endTime = System.nanoTime();
            totalTime += endTime - startTime;
        }
        i += k;
        return (long)(numIterations * numTrials) * 1000000000L / totalTime;
    }

    private static String spaceString(String str, int space) {
        if (str.length() == space) {
            return str;
        }
        if (str.length() >= space) {
            return str.substring(0, space);
        }
        String s = new String(str);
        for (int i = s.length(); i < space; ++i) {
            s = " " + s;
        }
        return s;
    }

    private static String formatDecimal(double n, int decimals) {
        String num = n + "";
        if (num.indexOf(".") == -1) {
            return num;
        }
        boolean ePresent = false;
        String e = null;
        if (num.indexOf("E") != -1) {
            e = num.substring(num.indexOf("E"));
            decimals -= e.length();
            num = num.substring(0, num.indexOf("E"));
            ePresent = true;
        }
        int decLen = num.substring(num.indexOf(".") + 1).length();
        int numLen = num.substring(0, num.indexOf(".")).length();
        if (decLen < decimals) {
            for (int i = 0; i < decimals - decLen; ++i) {
                num = num + " ";
            }
        } else if (decLen > decimals) {
            num = num.substring(0, numLen + decimals + 1);
        }
        if (ePresent) {
            num = num + e;
        }
        return num;
    }
}

