/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.dynamics.joints.RopeJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class RopeTest
extends TestbedTest {
    RopeJointDef m_ropeDef;
    Joint m_rope;

    @Override
    public void initTest(boolean deserialized) {
        if (deserialized) {
            return;
        }
        Body ground = null;
        BodyDef bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        ground.createFixture(shape, 0.0f);
        PolygonShape shape2 = new PolygonShape();
        shape2.setAsBox(0.5f, 0.125f);
        FixtureDef fd = new FixtureDef();
        fd.shape = shape2;
        fd.density = 20.0f;
        fd.friction = 0.2f;
        fd.filter.categoryBits = 1;
        fd.filter.maskBits = 65533;
        RevoluteJointDef jd = new RevoluteJointDef();
        jd.collideConnected = false;
        int N = 10;
        float y = 15.0f;
        this.m_ropeDef = new RopeJointDef();
        this.m_ropeDef.localAnchorA.set(0.0f, 15.0f);
        Body prevBody = ground;
        for (int i = 0; i < 10; ++i) {
            BodyDef bd2 = new BodyDef();
            bd2.type = BodyType.DYNAMIC;
            bd2.position.set(0.5f + 1.0f * (float)i, 15.0f);
            if (i == 9) {
                shape2.setAsBox(1.5f, 1.5f);
                fd.density = 100.0f;
                fd.filter.categoryBits = 2;
                bd2.position.set(1.0f * (float)i, 15.0f);
                bd2.angularDamping = 0.4f;
            }
            Body body = this.getWorld().createBody(bd2);
            body.createFixture(fd);
            Vec2 anchor = new Vec2(i, 15.0f);
            jd.initialize(prevBody, body, anchor);
            this.getWorld().createJoint(jd);
            prevBody = body;
        }
        this.m_ropeDef.localAnchorB.setZero();
        float extraLength = 0.01f;
        this.m_ropeDef.maxLength = 9.0f + extraLength;
        this.m_ropeDef.bodyB = prevBody;
        this.m_ropeDef.bodyA = ground;
        this.m_rope = this.getWorld().createJoint(this.m_ropeDef);
    }

    @Override
    public void keyPressed(char keyChar, int keyCode) {
        switch (keyChar) {
            case 'j': {
                if (this.m_rope != null) {
                    this.getWorld().destroyJoint(this.m_rope);
                    this.m_rope = null;
                    break;
                }
                this.m_rope = this.getWorld().createJoint(this.m_ropeDef);
            }
        }
    }

    @Override
    public synchronized void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("Press (j) to toggle the rope joint.");
        this.m_textLine += 15;
        if (this.m_rope != null) {
            this.addTextLine("Rope ON");
        } else {
            this.addTextLine("Rope OFF");
        }
    }

    @Override
    public String getTestName() {
        return "Rope Joint";
    }
}

