/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.callbacks.RayCastCallback;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.Fixture;

class RayCastMultipleCallback
implements RayCastCallback {
    public int e_maxCount = 5;
    Vec2[] m_points = new Vec2[this.e_maxCount];
    Vec2[] m_normals = new Vec2[this.e_maxCount];
    int m_count;

    RayCastMultipleCallback() {
    }

    public void init() {
        for (int i = 0; i < this.e_maxCount; ++i) {
            this.m_points[i] = new Vec2();
            this.m_normals[i] = new Vec2();
        }
        this.m_count = 0;
    }

    @Override
    public float reportFixture(Fixture fixture, Vec2 point, Vec2 normal, float fraction) {
        Body body = fixture.getBody();
        int index = 0;
        Object userData = body.getUserData();
        if (userData != null && (index = ((Integer)userData).intValue()) == 0) {
            return -1.0f;
        }
        assert (this.m_count < this.e_maxCount);
        this.m_points[this.m_count].set(point);
        this.m_normals[this.m_count].set(normal);
        ++this.m_count;
        if (this.m_count == this.e_maxCount) {
            return 0.0f;
        }
        return 1.0f;
    }
}

