/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.framework.TestbedTest;

public class FixedPendulumTest
extends TestbedTest {
    private final boolean switchBodiesInJoint;

    public FixedPendulumTest(boolean switchBodiesInJoint) {
        this.switchBodiesInJoint = switchBodiesInJoint;
    }

    @Override
    public void initTest(boolean argDeserialized) {
        CircleShape circleShape = new CircleShape();
        circleShape.m_radius = 1.0f;
        CircleShape shape = circleShape;
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        bodyDef.position.set(-5.0f, 0.0f);
        bodyDef.allowSleep = false;
        Body pendulum = this.getWorld().createBody(bodyDef);
        pendulum.createFixture(shape, 1.0f);
        BodyDef bodyDef2 = new BodyDef();
        bodyDef2.type = BodyType.STATIC;
        Body ground = this.getWorld().createBody(bodyDef2);
        RevoluteJointDef jointDef = new RevoluteJointDef();
        if (this.switchBodiesInJoint) {
            jointDef.initialize(pendulum, ground, new Vec2(0.0f, 0.0f));
        } else {
            jointDef.initialize(ground, pendulum, new Vec2(0.0f, 0.0f));
        }
        pendulum.applyAngularImpulse(10000.0f);
        this.getWorld().createJoint(jointDef);
    }

    @Override
    public String getTestName() {
        return "Fixed Pendulum " + (this.switchBodiesInJoint ? "1" : "0");
    }
}

