/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.testbed.framework.TestbedTest;

public class DominoTower
extends TestbedTest {
    final float dwidth = 0.2f;
    final float dheight = 1.0f;
    float ddensity;
    final float dfriction = 0.1f;
    int baseCount = 25;

    public void makeDomino(float x, float y, boolean horizontal, World world) {
        PolygonShape sd = new PolygonShape();
        sd.setAsBox(0.1f, 0.5f);
        FixtureDef fd = new FixtureDef();
        fd.shape = sd;
        fd.density = this.ddensity;
        BodyDef bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        fd.friction = 0.1f;
        fd.restitution = 0.65f;
        bd.position = new Vec2(x, y);
        bd.angle = horizontal ? 1.5707964f : 0.0f;
        Body myBody = this.getWorld().createBody(bd);
        myBody.createFixture(fd);
    }

    @Override
    public Vec2 getDefaultCameraPos() {
        return new Vec2(0.0f, 12.0f);
    }

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean argDeserialized) {
        if (argDeserialized) {
            return;
        }
        PolygonShape sd = new PolygonShape();
        sd.setAsBox(50.0f, 10.0f);
        BodyDef bd = new BodyDef();
        bd.position = new Vec2(0.0f, -10.0f);
        this.getWorld().createBody(bd).createFixture(sd, 0.0f);
        this.ddensity = 10.0f;
        sd = new PolygonShape();
        sd.setAsBox(0.7f, 0.7f);
        FixtureDef fd = new FixtureDef();
        fd.density = 35.0f;
        BodyDef bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        fd.shape = sd;
        fd.friction = 0.0f;
        fd.restitution = 0.85f;
        bd2.bullet = true;
        bd2.position = new Vec2(30.0f, 50.0f);
        Body b = this.getWorld().createBody(bd2);
        b.createFixture(fd);
        b.setLinearVelocity(new Vec2(-25.0f, -25.0f));
        b.setAngularVelocity(6.7f);
        fd.density = 25.0f;
        bd2.position = new Vec2(-30.0f, 25.0f);
        b = this.getWorld().createBody(bd2);
        b.createFixture(fd);
        b.setLinearVelocity(new Vec2(35.0f, -10.0f));
        b.setAngularVelocity(-8.3f);
        for (int i = 0; i < this.baseCount; ++i) {
            float currX = (float)i * 1.5f * 1.0f - 1.5f * (float)this.baseCount / 2.0f;
            this.makeDomino(currX, 0.5f, false, this.m_world);
            this.makeDomino(currX, 1.1f, true, this.m_world);
        }
        float currX = (float)this.baseCount * 1.5f * 1.0f - 1.5f * (float)this.baseCount / 2.0f;
        for (int j = 1; j < this.baseCount; ++j) {
            if (j > 3) {
                this.ddensity *= 0.8f;
            }
            float currY = 0.5f + 1.386f * (float)j;
            for (int i = 0; i < this.baseCount - j; ++i) {
                currX = (float)i * 1.5f * 1.0f - 1.5f * (float)(this.baseCount - j) / 2.0f;
                this.ddensity *= 2.5f;
                if (i == 0) {
                    this.makeDomino(currX - 1.25f + 0.1f, currY - 0.2f, false, this.m_world);
                }
                if (i == this.baseCount - j - 1) {
                    this.makeDomino(currX + 1.25f - 0.1f, currY - 0.2f, false, this.m_world);
                }
                this.ddensity /= 2.5f;
                this.makeDomino(currX, currY, false, this.m_world);
                this.makeDomino(currX, currY + 0.6f, true, this.m_world);
                this.makeDomino(currX, currY - 0.6f, true, this.m_world);
            }
        }
    }

    @Override
    public String getTestName() {
        return "Domino Tower";
    }
}

