/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.dynamics.joints.WheelJoint;
import org.jbox2d.dynamics.joints.WheelJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class Car
extends TestbedTest {
    private static final long CAR_TAG = 100L;
    private static final long WHEEL1_TAG = 101L;
    private static final long WHEEL2_TAG = 102L;
    private static final long SPRING1_TAG = 103L;
    private static final long SPRING2_TAG = 104L;
    private Body m_car;
    private Body m_wheel1;
    private Body m_wheel2;
    private float m_hz;
    private float m_zeta;
    private float m_speed;
    private WheelJoint m_spring1;
    private WheelJoint m_spring2;

    @Override
    public Long getTag(Body body) {
        if (body == this.m_car) {
            return 100L;
        }
        if (body == this.m_wheel1) {
            return 101L;
        }
        if (body == this.m_wheel2) {
            return 102L;
        }
        return super.getTag(body);
    }

    @Override
    public Long getTag(Joint joint) {
        if (joint == this.m_spring1) {
            return 103L;
        }
        if (joint == this.m_spring2) {
            return 104L;
        }
        return super.getTag(joint);
    }

    @Override
    public void processBody(Body body, Long tag) {
        if (tag == 100L) {
            this.m_car = body;
        } else if (tag == 101L) {
            this.m_wheel1 = body;
        } else if (tag == 102L) {
            this.m_wheel2 = body;
        } else {
            super.processBody(body, tag);
        }
    }

    @Override
    public void processJoint(Joint joint, Long tag) {
        if (tag == 103L) {
            this.m_spring1 = (WheelJoint)joint;
        } else if (tag == 104L) {
            this.m_spring2 = (WheelJoint)joint;
        } else {
            super.processJoint(joint, tag);
        }
    }

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public String getTestName() {
        return "Car";
    }

    @Override
    public void initTest(boolean deserialized) {
        float y2;
        int i;
        if (deserialized) {
            return;
        }
        this.m_hz = 4.0f;
        this.m_zeta = 0.7f;
        this.m_speed = 50.0f;
        Body ground = null;
        BodyDef bd = new BodyDef();
        ground = this.m_world.createBody(bd);
        Shape shape = new EdgeShape();
        FixtureDef fd = new FixtureDef();
        fd.shape = shape;
        fd.density = 0.0f;
        fd.friction = 0.6f;
        ((EdgeShape)shape).set(new Vec2(-20.0f, 0.0f), new Vec2(20.0f, 0.0f));
        ground.createFixture(fd);
        float[] hs = new float[]{0.25f, 1.0f, 4.0f, 0.0f, 0.0f, -1.0f, -2.0f, -2.0f, -1.25f, 0.0f};
        float x = 20.0f;
        float y1 = 0.0f;
        float dx = 5.0f;
        for (i = 0; i < 10; ++i) {
            y2 = hs[i];
            ((EdgeShape)shape).set(new Vec2(x, y1), new Vec2(x + dx, y2));
            ground.createFixture(fd);
            y1 = y2;
            x += dx;
        }
        for (i = 0; i < 10; ++i) {
            y2 = hs[i];
            ((EdgeShape)shape).set(new Vec2(x, y1), new Vec2(x + dx, y2));
            ground.createFixture(fd);
            y1 = y2;
            x += dx;
        }
        ((EdgeShape)shape).set(new Vec2(x, 0.0f), new Vec2(x + 40.0f, 0.0f));
        ground.createFixture(fd);
        ((EdgeShape)shape).set(new Vec2(x += 80.0f, 0.0f), new Vec2(x + 40.0f, 0.0f));
        ground.createFixture(fd);
        ((EdgeShape)shape).set(new Vec2(x += 40.0f, 0.0f), new Vec2(x + 10.0f, 5.0f));
        ground.createFixture(fd);
        ((EdgeShape)shape).set(new Vec2(x += 20.0f, 0.0f), new Vec2(x + 40.0f, 0.0f));
        ground.createFixture(fd);
        ((EdgeShape)shape).set(new Vec2(x += 40.0f, 0.0f), new Vec2(x, 20.0f));
        ground.createFixture(fd);
        bd = new BodyDef();
        bd.position.set(140.0f, 1.0f);
        bd.type = BodyType.DYNAMIC;
        Body body = this.m_world.createBody(bd);
        PolygonShape box = new PolygonShape();
        box.setAsBox(10.0f, 0.25f);
        body.createFixture(box, 1.0f);
        RevoluteJointDef jd = new RevoluteJointDef();
        jd.initialize(ground, body, body.getPosition());
        jd.lowerAngle = -0.13962634f;
        jd.upperAngle = 0.13962634f;
        jd.enableLimit = true;
        this.m_world.createJoint(jd);
        body.applyAngularImpulse(100.0f);
        int N = 20;
        shape = new PolygonShape();
        ((PolygonShape)shape).setAsBox(1.0f, 0.125f);
        fd = new FixtureDef();
        fd.shape = shape;
        fd.density = 1.0f;
        fd.friction = 0.6f;
        jd = new RevoluteJointDef();
        Body prevBody = ground;
        for (int i2 = 0; i2 < N; ++i2) {
            BodyDef bd2 = new BodyDef();
            bd2.type = BodyType.DYNAMIC;
            bd2.position.set(161.0f + 2.0f * (float)i2, -0.125f);
            Body body2 = this.m_world.createBody(bd2);
            body2.createFixture(fd);
            Vec2 anchor = new Vec2(160.0f + 2.0f * (float)i2, -0.125f);
            jd.initialize(prevBody, body2, anchor);
            this.m_world.createJoint(jd);
            prevBody = body2;
        }
        Vec2 anchor = new Vec2(160.0f + 2.0f * (float)N, -0.125f);
        jd.initialize(prevBody, ground, anchor);
        this.m_world.createJoint(jd);
        PolygonShape box2 = new PolygonShape();
        box2.setAsBox(0.5f, 0.5f);
        body = null;
        BodyDef bd3 = new BodyDef();
        bd3.type = BodyType.DYNAMIC;
        bd3.position.set(230.0f, 0.5f);
        body = this.m_world.createBody(bd3);
        body.createFixture(box2, 0.5f);
        bd3.position.set(230.0f, 1.5f);
        body = this.m_world.createBody(bd3);
        body.createFixture(box2, 0.5f);
        bd3.position.set(230.0f, 2.5f);
        body = this.m_world.createBody(bd3);
        body.createFixture(box2, 0.5f);
        bd3.position.set(230.0f, 3.5f);
        body = this.m_world.createBody(bd3);
        body.createFixture(box2, 0.5f);
        bd3.position.set(230.0f, 4.5f);
        body = this.m_world.createBody(bd3);
        body.createFixture(box2, 0.5f);
        PolygonShape chassis = new PolygonShape();
        Vec2[] vertices = new Vec2[8];
        vertices[0] = new Vec2(-1.5f, -0.5f);
        vertices[1] = new Vec2(1.5f, -0.5f);
        vertices[2] = new Vec2(1.5f, 0.0f);
        vertices[3] = new Vec2(0.0f, 0.9f);
        vertices[4] = new Vec2(-1.15f, 0.9f);
        vertices[5] = new Vec2(-1.5f, 0.2f);
        chassis.set(vertices, 6);
        CircleShape circle = new CircleShape();
        circle.m_radius = 0.4f;
        BodyDef bd4 = new BodyDef();
        bd4.type = BodyType.DYNAMIC;
        bd4.position.set(0.0f, 1.0f);
        this.m_car = this.m_world.createBody(bd4);
        this.m_car.createFixture(chassis, 1.0f);
        FixtureDef fd2 = new FixtureDef();
        fd2.shape = circle;
        fd2.density = 1.0f;
        fd2.friction = 0.9f;
        bd4.position.set(-1.0f, 0.35f);
        this.m_wheel1 = this.m_world.createBody(bd4);
        this.m_wheel1.createFixture(fd2);
        bd4.position.set(1.0f, 0.4f);
        this.m_wheel2 = this.m_world.createBody(bd4);
        this.m_wheel2.createFixture(fd2);
        WheelJointDef jd2 = new WheelJointDef();
        Vec2 axis = new Vec2(0.0f, 1.0f);
        jd2.initialize(this.m_car, this.m_wheel1, this.m_wheel1.getPosition(), axis);
        jd2.motorSpeed = 0.0f;
        jd2.maxMotorTorque = 20.0f;
        jd2.enableMotor = true;
        jd2.frequencyHz = this.m_hz;
        jd2.dampingRatio = this.m_zeta;
        this.m_spring1 = (WheelJoint)this.m_world.createJoint(jd2);
        jd2.initialize(this.m_car, this.m_wheel2, this.m_wheel2.getPosition(), axis);
        jd2.motorSpeed = 0.0f;
        jd2.maxMotorTorque = 10.0f;
        jd2.enableMotor = false;
        jd2.frequencyHz = this.m_hz;
        jd2.dampingRatio = this.m_zeta;
        this.m_spring2 = (WheelJoint)this.m_world.createJoint(jd2);
    }

    @Override
    public void keyPressed(char argKeyChar, int argKeyCode) {
        switch (argKeyChar) {
            case 'a': {
                this.m_spring1.EnableMotor(true);
                this.m_spring1.setMotorSpeed(this.m_speed);
                break;
            }
            case 's': {
                this.m_spring1.EnableMotor(true);
                this.m_spring1.setMotorSpeed(0.0f);
                break;
            }
            case 'd': {
                this.m_spring1.EnableMotor(true);
                this.m_spring1.setMotorSpeed(-this.m_speed);
                break;
            }
            case 'q': {
                this.m_hz = MathUtils.max(0.0f, this.m_hz - 1.0f);
                this.m_spring1.setSpringFrequencyHz(this.m_hz);
                this.m_spring2.setSpringFrequencyHz(this.m_hz);
                break;
            }
            case 'e': {
                this.m_hz += 1.0f;
                this.m_spring1.setSpringFrequencyHz(this.m_hz);
                this.m_spring2.setSpringFrequencyHz(this.m_hz);
            }
        }
    }

    @Override
    public void keyReleased(char argKeyChar, int argKeyCode) {
        super.keyReleased(argKeyChar, argKeyCode);
        switch (argKeyChar) {
            case 'a': 
            case 'd': 
            case 's': {
                this.m_spring1.EnableMotor(false);
            }
        }
    }

    @Override
    public float getDefaultCameraScale() {
        return 15.0f;
    }

    @Override
    public synchronized void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("Keys: left = a, brake = s, right = d, hz down = q, hz up = e");
        this.addTextLine("frequency = " + this.m_hz + " hz, damping ratio = " + this.m_zeta);
        this.setCamera(this.m_car.getPosition());
    }
}

