/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.perf;

import org.jbox2d.common.MathUtils;
import org.jbox2d.testbed.perf.PerfTest;

public class MathPerf
extends PerfTest {
    public static int INNER_ITERS = 500000;
    public static int OUTER_ITERS = 100;
    String[] tests = new String[]{"Sin", "SinLUT", "Pow", "FastPow", "Max", "FastMax", "Floor", "fastFloor", "aTan2", "fastATan2", "ceil", "fastCeil"};
    public float aStore = 0.0f;

    public MathPerf() {
        super(12, OUTER_ITERS);
    }

    @Override
    public void runTest(int argNum) {
        float random = MathUtils.randomFloat(-1.1342745E38f, 1.1342745E38f);
        switch (argNum) {
            case 0: {
                this.runSinTest(random);
                break;
            }
            case 1: {
                this.runSinLUTTest(random);
                break;
            }
            case 2: {
                this.runPowTest(random);
                break;
            }
            case 3: {
                this.runFastPowTest(random);
                break;
            }
            case 4: {
                this.runMaxTest(random);
                break;
            }
            case 5: {
                this.runFastMaxTest(random);
                break;
            }
            case 6: {
                this.runFloorTest(random);
                break;
            }
            case 7: {
                this.runFastFloorTest(random);
                break;
            }
            case 8: {
                this.runAtan2Test(random);
                break;
            }
            case 9: {
                this.runFastAtan2Test(random);
                break;
            }
            case 10: {
                this.runCeilTest(random);
                break;
            }
            case 11: {
                this.runFastCeilTest(random);
            }
        }
    }

    public void runSinTest(float argRandom) {
        float a = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            a = (float)StrictMath.sin(argRandom);
        }
        this.aStore += a;
    }

    public void runSinLUTTest(float argRandom) {
        float a = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            a = MathUtils.sinLUT(argRandom);
        }
        this.aStore += a;
    }

    public void runPowTest(float argRandom) {
        float a = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            a = (float)StrictMath.pow(argRandom, MathUtils.randomFloat(-100.0f, 100.0f));
        }
        this.aStore += a;
    }

    public void runFastPowTest(float argRandom) {
        float a = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            a = MathUtils.fastPow(argRandom, MathUtils.randomFloat(-100.0f, 100.0f));
        }
        this.aStore += a;
    }

    public void runMaxTest(float argRandom) {
        float a = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            a = StrictMath.max(argRandom, MathUtils.randomFloat(-100.0f, 100.0f));
        }
        this.aStore += a;
    }

    public void runFastMaxTest(float argRandom) {
        float a = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            a = MathUtils.max(argRandom, MathUtils.randomFloat(-100.0f, 100.0f));
        }
        this.aStore += a;
    }

    public void runFloorTest(float argRandom) {
        float a = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            a = (float)StrictMath.floor(argRandom);
        }
        this.aStore += a;
    }

    public void runFastFloorTest(float argRandom) {
        float a = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            a = MathUtils.floor(argRandom);
        }
        this.aStore += a;
    }

    public void runAtan2Test(float argRandom) {
        float a = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            a = (float)StrictMath.atan2(argRandom, MathUtils.randomFloat(-10000.0f, 10000.0f));
        }
        this.aStore += a;
    }

    public void runFastAtan2Test(float argRandom) {
        float a = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            a = MathUtils.fastAtan2(argRandom, MathUtils.randomFloat(-10000.0f, 10000.0f));
        }
        this.aStore += a;
    }

    public void runCeilTest(float argRandom) {
        float a = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            a = (float)StrictMath.ceil(argRandom);
        }
        this.aStore += a;
    }

    public void runFastCeilTest(float argRandom) {
        float a = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            a = MathUtils.ceil(argRandom);
        }
        this.aStore += a;
    }

    @Override
    public String getTestName(int argNum) {
        return this.tests[argNum];
    }

    public static void main(String[] c) {
        MathPerf p = new MathPerf();
        p.go();
    }
}

