/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.serialization.pb;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.box2d.proto.Box2D;
import org.jbox2d.collision.shapes.ChainShape;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.Filter;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.ConstantVolumeJoint;
import org.jbox2d.dynamics.joints.DistanceJoint;
import org.jbox2d.dynamics.joints.FrictionJoint;
import org.jbox2d.dynamics.joints.GearJoint;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.MouseJoint;
import org.jbox2d.dynamics.joints.PrismaticJoint;
import org.jbox2d.dynamics.joints.PulleyJoint;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RopeJoint;
import org.jbox2d.dynamics.joints.WeldJoint;
import org.jbox2d.dynamics.joints.WheelJoint;
import org.jbox2d.serialization.JbSerializer;
import org.jbox2d.serialization.SerializationHelper;
import org.jbox2d.serialization.SerializationResult;
import org.jbox2d.serialization.UnsupportedListener;
import org.jbox2d.serialization.UnsupportedObjectException;

public class PbSerializer
implements JbSerializer {
    private JbSerializer.ObjectSigner signer = null;
    private UnsupportedListener listener = null;

    public PbSerializer() {
    }

    public PbSerializer(UnsupportedListener argListener) {
        this.listener = argListener;
    }

    public PbSerializer(JbSerializer.ObjectSigner argSigner) {
        this.signer = argSigner;
    }

    public PbSerializer(UnsupportedListener argListener, JbSerializer.ObjectSigner argSigner) {
        this.listener = argListener;
        this.signer = argSigner;
    }

    @Override
    public void setObjectSigner(JbSerializer.ObjectSigner argSigner) {
        this.signer = argSigner;
    }

    @Override
    public void setUnsupportedListener(UnsupportedListener argListener) {
        this.listener = argListener;
    }

    @Override
    public SerializationResult serialize(World argWorld) {
        final Box2D.PbWorld world = this.serializeWorld(argWorld).build();
        return new SerializationResult(){

            @Override
            public void writeTo(OutputStream argOutputStream) throws IOException {
                world.writeTo(argOutputStream);
            }

            @Override
            public Object getValue() {
                return world;
            }
        };
    }

    public Box2D.PbWorld.Builder serializeWorld(World argWorld) {
        Long tag;
        Box2D.PbWorld.Builder builder = Box2D.PbWorld.newBuilder();
        if (this.signer != null && (tag = this.signer.getTag(argWorld)) != null) {
            builder.setTag(tag.longValue());
        }
        builder.setGravity(this.vecToPb(argWorld.getGravity()));
        builder.setAllowSleep(argWorld.isAllowSleep());
        builder.setContinuousPhysics(argWorld.isContinuousPhysics());
        builder.setWarmStarting(argWorld.isWarmStarting());
        builder.setSubStepping(argWorld.isSubStepping());
        Body cbody = argWorld.getBodyList();
        int cnt = 0;
        HashMap<Body, Integer> bodies = new HashMap<Body, Integer>();
        while (cbody != null) {
            builder.addBodies(this.serializeBody(cbody));
            bodies.put(cbody, cnt);
            ++cnt;
            cbody = cbody.m_next;
        }
        cnt = 0;
        HashMap<Joint, Integer> joints = new HashMap<Joint, Integer>();
        Joint cjoint = argWorld.getJointList();
        while (cjoint != null) {
            if (SerializationHelper.isIndependentJoint(cjoint.getType())) {
                builder.addJoints(this.serializeJoint(cjoint, bodies, joints));
                joints.put(cjoint, cnt);
                ++cnt;
            }
            cjoint = cjoint.m_next;
        }
        cjoint = argWorld.getJointList();
        while (cjoint != null) {
            if (!SerializationHelper.isIndependentJoint(cjoint.getType())) {
                builder.addJoints(this.serializeJoint(cjoint, bodies, joints));
                joints.put(cjoint, cnt);
                ++cnt;
            }
            cjoint = cjoint.m_next;
        }
        return builder;
    }

    @Override
    public SerializationResult serialize(Body argBody) {
        Box2D.PbBody.Builder builder = this.serializeBody(argBody);
        if (builder == null) {
            return null;
        }
        final Box2D.PbBody body = builder.build();
        return new SerializationResult(){

            @Override
            public void writeTo(OutputStream argOutputStream) throws IOException {
                body.writeTo(argOutputStream);
            }

            @Override
            public Object getValue() {
                return body;
            }
        };
    }

    public Box2D.PbBody.Builder serializeBody(Body argBody) {
        Long id;
        Box2D.PbBody.Builder builder = Box2D.PbBody.newBuilder();
        if (this.signer != null && (id = this.signer.getTag(argBody)) != null) {
            builder.setTag(id.longValue());
        }
        switch (argBody.getType()) {
            case DYNAMIC: {
                builder.setType(Box2D.PbBodyType.DYNAMIC);
                break;
            }
            case KINEMATIC: {
                builder.setType(Box2D.PbBodyType.KINEMATIC);
                break;
            }
            case STATIC: {
                builder.setType(Box2D.PbBodyType.STATIC);
                break;
            }
            default: {
                UnsupportedObjectException e = new UnsupportedObjectException("Unknown body type: " + (Object)((Object)argBody.getType()), UnsupportedObjectException.Type.BODY);
                if (this.listener == null || this.listener.isUnsupported(e)) {
                    throw e;
                }
                return null;
            }
        }
        builder.setPosition(this.vecToPb(argBody.getPosition()));
        builder.setAngle(argBody.getAngle());
        builder.setLinearVelocity(this.vecToPb(argBody.getLinearVelocity()));
        builder.setAngularVelocity(argBody.getAngularVelocity());
        builder.setLinearDamping(argBody.getLinearDamping());
        builder.setAngularDamping(argBody.getAngularDamping());
        builder.setGravityScale(argBody.getGravityScale());
        builder.setBullet(argBody.isBullet());
        builder.setAllowSleep(argBody.isSleepingAllowed());
        builder.setAwake(argBody.isAwake());
        builder.setActive(argBody.isActive());
        builder.setFixedRotation(argBody.isFixedRotation());
        Fixture curr = argBody.m_fixtureList;
        while (curr != null) {
            builder.addFixtures(this.serializeFixture(curr));
            curr = curr.m_next;
        }
        return builder;
    }

    @Override
    public SerializationResult serialize(Fixture argFixture) {
        final Box2D.PbFixture fixture = this.serializeFixture(argFixture).build();
        return new SerializationResult(){

            @Override
            public void writeTo(OutputStream argOutputStream) throws IOException {
                fixture.writeTo(argOutputStream);
            }

            @Override
            public Object getValue() {
                return fixture;
            }
        };
    }

    public Box2D.PbFixture.Builder serializeFixture(Fixture argFixture) {
        Long tag;
        Box2D.PbFixture.Builder builder = Box2D.PbFixture.newBuilder();
        if (this.signer != null && (tag = this.signer.getTag(argFixture)) != null) {
            builder.setTag(tag.longValue());
        }
        builder.setDensity(argFixture.m_density);
        builder.setFriction(argFixture.m_friction);
        builder.setRestitution(argFixture.m_restitution);
        builder.setSensor(argFixture.m_isSensor);
        builder.setShape(this.serializeShape(argFixture.m_shape));
        builder.setFilter(this.serializeFilter(argFixture.m_filter));
        return builder;
    }

    @Override
    public SerializationResult serialize(Shape argShape) {
        Box2D.PbShape.Builder builder = this.serializeShape(argShape);
        if (builder == null) {
            return null;
        }
        final Box2D.PbShape shape = builder.build();
        return new SerializationResult(){

            @Override
            public void writeTo(OutputStream argOutputStream) throws IOException {
                shape.writeTo(argOutputStream);
            }

            @Override
            public Object getValue() {
                return shape;
            }
        };
    }

    public Box2D.PbShape.Builder serializeShape(Shape argShape) {
        Long tag;
        Box2D.PbShape.Builder builder = Box2D.PbShape.newBuilder();
        if (this.signer != null && (tag = this.signer.getTag(argShape)) != null) {
            builder.setTag(tag.longValue());
        }
        builder.setRadius(argShape.m_radius);
        switch (argShape.m_type) {
            case CIRCLE: {
                CircleShape c = (CircleShape)argShape;
                builder.setType(Box2D.PbShapeType.CIRCLE);
                builder.setCenter(this.vecToPb(c.m_p));
                break;
            }
            case POLYGON: {
                PolygonShape p = (PolygonShape)argShape;
                builder.setType(Box2D.PbShapeType.POLYGON);
                builder.setCentroid(this.vecToPb(p.m_centroid));
                int i = 0;
                while (i < p.m_count) {
                    builder.addPoints(this.vecToPb(p.m_vertices[i]));
                    builder.addNormals(this.vecToPb(p.m_normals[i]));
                    ++i;
                }
                break;
            }
            case EDGE: {
                EdgeShape e = (EdgeShape)argShape;
                builder.setType(Box2D.PbShapeType.EDGE);
                builder.setV0(this.vecToPb(e.m_vertex0));
                builder.setV1(this.vecToPb(e.m_vertex1));
                builder.setV2(this.vecToPb(e.m_vertex2));
                builder.setV3(this.vecToPb(e.m_vertex3));
                builder.setHas0(e.m_hasVertex0);
                builder.setHas3(e.m_hasVertex3);
                break;
            }
            case CHAIN: {
                ChainShape h = (ChainShape)argShape;
                builder.setType(Box2D.PbShapeType.CHAIN);
                int i = 0;
                while (i < h.m_count) {
                    builder.addPoints(this.vecToPb(h.m_vertices[i]));
                    ++i;
                }
                builder.setPrev(this.vecToPb(h.m_prevVertex));
                builder.setNext(this.vecToPb(h.m_nextVertex));
                builder.setHas0(h.m_hasPrevVertex);
                builder.setHas3(h.m_hasNextVertex);
                break;
            }
            default: {
                UnsupportedObjectException ex = new UnsupportedObjectException("Currently only encodes circle and polygon shapes", UnsupportedObjectException.Type.SHAPE);
                if (this.listener == null || this.listener.isUnsupported(ex)) {
                    throw ex;
                }
                return null;
            }
        }
        return builder;
    }

    @Override
    public SerializationResult serialize(Joint argJoint, Map<Body, Integer> argBodyIndexMap, Map<Joint, Integer> argJointIndexMap) {
        Box2D.PbJoint.Builder builder = this.serializeJoint(argJoint, argBodyIndexMap, argJointIndexMap);
        if (builder == null) {
            return null;
        }
        final Box2D.PbJoint joint = builder.build();
        return new SerializationResult(){

            @Override
            public void writeTo(OutputStream argOutputStream) throws IOException {
                joint.writeTo(argOutputStream);
            }

            @Override
            public Object getValue() {
                return joint;
            }
        };
    }

    public Box2D.PbJoint.Builder serializeJoint(Joint joint, Map<Body, Integer> argBodyIndexMap, Map<Joint, Integer> argJointIndexMap) {
        Box2D.PbJoint.Builder builder = Box2D.PbJoint.newBuilder();
        if (this.signer != null) {
            Long tag = this.signer.getTag(joint);
            if (tag != null) {
                builder.setTag(tag.longValue());
            } else {
                builder.clearTag();
            }
        }
        Body bA = joint.m_bodyA;
        Body bB = joint.m_bodyB;
        if (!argBodyIndexMap.containsKey(bA)) {
            throw new IllegalArgumentException("Body " + bA + " is not present in the index map");
        }
        builder.setBodyA(argBodyIndexMap.get(bA).intValue());
        if (!argBodyIndexMap.containsKey(bB)) {
            throw new IllegalArgumentException("Body " + bB + " is not present in the index map");
        }
        builder.setBodyB(argBodyIndexMap.get(bB).intValue());
        builder.setCollideConnected(joint.m_collideConnected);
        switch (joint.m_type) {
            case REVOLUTE: {
                RevoluteJoint j = (RevoluteJoint)joint;
                builder.setType(Box2D.PbJointType.REVOLUTE);
                builder.setLocalAnchorA(this.vecToPb(j.m_localAnchorA));
                builder.setLocalAnchorB(this.vecToPb(j.m_localAnchorB));
                builder.setRefAngle(j.m_referenceAngle);
                builder.setEnableLimit(j.m_enableLimit);
                builder.setLowerLimit(j.m_lowerAngle);
                builder.setUpperLimit(j.m_upperAngle);
                builder.setEnableMotor(j.m_enableMotor);
                builder.setMotorSpeed(j.m_motorSpeed);
                builder.setMaxMotorTorque(j.m_maxMotorTorque);
                break;
            }
            case PRISMATIC: {
                PrismaticJoint j = (PrismaticJoint)joint;
                builder.setType(Box2D.PbJointType.PRISMATIC);
                builder.setLocalAnchorA(this.vecToPb(j.m_localAnchorA));
                builder.setLocalAnchorB(this.vecToPb(j.m_localAnchorB));
                builder.setLocalAxisA(this.vecToPb(j.m_localXAxisA));
                builder.setRefAngle(j.m_referenceAngle);
                builder.setEnableLimit(j.m_enableLimit);
                builder.setLowerLimit(j.m_lowerTranslation);
                builder.setUpperLimit(j.m_upperTranslation);
                builder.setEnableMotor(j.m_enableMotor);
                builder.setMaxMotorForce(j.m_maxMotorForce);
                builder.setMotorSpeed(j.m_motorSpeed);
                break;
            }
            case DISTANCE: {
                DistanceJoint j = (DistanceJoint)joint;
                builder.setType(Box2D.PbJointType.DISTANCE);
                builder.setLocalAnchorA(this.vecToPb(j.m_localAnchorA));
                builder.setLocalAnchorB(this.vecToPb(j.m_localAnchorB));
                builder.setLength(j.m_length);
                builder.setFrequency(j.m_frequencyHz);
                builder.setDampingRatio(j.m_dampingRatio);
                break;
            }
            case PULLEY: {
                PulleyJoint j = (PulleyJoint)joint;
                builder.setType(Box2D.PbJointType.PULLEY);
                builder.setLocalAnchorA(this.vecToPb(j.m_localAnchorA));
                builder.setLocalAnchorB(this.vecToPb(j.m_localAnchorB));
                builder.setGroundAnchorA(this.vecToPb(j.m_groundAnchorA));
                builder.setGroundAnchorB(this.vecToPb(j.m_groundAnchorB));
                builder.setLengthA(j.getLengthA());
                builder.setLengthB(j.getLengthB());
                builder.setRatio(j.getRatio());
                break;
            }
            case MOUSE: {
                MouseJoint j = (MouseJoint)joint;
                builder.setType(Box2D.PbJointType.MOUSE);
                builder.setTarget(this.vecToPb(j.getTarget()));
                builder.setMaxForce(j.getMaxForce());
                builder.setFrequency(j.getFrequency());
                builder.setDampingRatio(j.getDampingRatio());
                break;
            }
            case GEAR: {
                GearJoint j = (GearJoint)joint;
                builder.setType(Box2D.PbJointType.GEAR);
                builder.setRatio(j.getRatio());
                if (!argJointIndexMap.containsKey(j.getJoint1())) {
                    throw new IllegalArgumentException("Joint 1 not in map");
                }
                int j1 = argJointIndexMap.get(j.getJoint1());
                if (!argJointIndexMap.containsKey(j.getJoint2())) {
                    throw new IllegalArgumentException("Joint 2 not in map");
                }
                int j2 = argJointIndexMap.get(j.getJoint2());
                builder.setJoint1(j1);
                builder.setJoint2(j2);
                break;
            }
            case FRICTION: {
                FrictionJoint j = (FrictionJoint)joint;
                builder.setType(Box2D.PbJointType.FRICTION);
                builder.setLocalAnchorA(this.vecToPb(j.getLocalAnchorA()));
                builder.setLocalAnchorB(this.vecToPb(j.getLocalAnchorB()));
                builder.setMaxForce(j.getMaxForce());
                builder.setMaxTorque(j.getMaxTorque());
                break;
            }
            case CONSTANT_VOLUME: {
                ConstantVolumeJoint j = (ConstantVolumeJoint)joint;
                builder.setType(Box2D.PbJointType.CONSTANT_VOLUME);
                builder.setFrequency(j.frequencyHz);
                builder.setDampingRatio(j.dampingRatio);
                int i = 0;
                while (i < j.bodies.length) {
                    Body b = j.bodies[i];
                    DistanceJoint djoint = j.getJoints()[i];
                    if (!argBodyIndexMap.containsKey(b)) {
                        throw new IllegalArgumentException("Body " + b + " is not present in the index map");
                    }
                    builder.addBodies(argBodyIndexMap.get(b).intValue());
                    if (!argJointIndexMap.containsKey(djoint)) {
                        throw new IllegalArgumentException("Joint " + djoint + " is not present in the index map");
                    }
                    builder.addJoints(argJointIndexMap.get(djoint).intValue());
                    ++i;
                }
                break;
            }
            case WHEEL: {
                WheelJoint j = (WheelJoint)joint;
                builder.setType(Box2D.PbJointType.WHEEL);
                builder.setLocalAnchorA(this.vecToPb(j.m_localAnchorA));
                builder.setLocalAnchorB(this.vecToPb(j.m_localAnchorB));
                builder.setLocalAxisA(this.vecToPb(j.m_localXAxisA));
                builder.setEnableMotor(j.isMotorEnabled());
                builder.setMaxMotorTorque(j.getMaxMotorTorque());
                builder.setMotorSpeed(j.getMotorSpeed());
                builder.setFrequency(j.m_frequencyHz);
                builder.setDampingRatio(j.m_dampingRatio);
                break;
            }
            case ROPE: {
                RopeJoint j = (RopeJoint)joint;
                builder.setType(Box2D.PbJointType.ROPE);
                builder.setLocalAnchorA(this.vecToPb(j.m_localAnchorA));
                builder.setLocalAnchorB(this.vecToPb(j.m_localAnchorB));
                builder.setMaxLength(j.m_maxLength);
                break;
            }
            case WELD: {
                WeldJoint j = (WeldJoint)joint;
                builder.setType(Box2D.PbJointType.WELD);
                builder.setLocalAnchorA(this.vecToPb(j.m_localAnchorA));
                builder.setLocalAnchorB(this.vecToPb(j.m_localAnchorB));
                builder.setRefAngle(j.m_referenceAngle);
                builder.setFrequency(j.m_frequencyHz);
                builder.setDampingRatio(j.m_dampingRatio);
                break;
            }
            default: {
                UnsupportedObjectException e = new UnsupportedObjectException("Unknown joint type: " + (Object)((Object)joint.getType()), UnsupportedObjectException.Type.JOINT);
                if (this.listener == null || this.listener.isUnsupported(e)) {
                    throw e;
                }
                return null;
            }
        }
        return builder;
    }

    public Box2D.PbFilter.Builder serializeFilter(Filter argFilter) {
        Box2D.PbFilter.Builder builder = Box2D.PbFilter.newBuilder();
        builder.setCategoryBits(argFilter.categoryBits);
        builder.setGroupIndex(argFilter.groupIndex);
        builder.setMaskBits(argFilter.maskBits);
        return builder;
    }

    private Box2D.PbVec2 vecToPb(Vec2 argVec) {
        if (argVec == null) {
            return null;
        }
        return Box2D.PbVec2.newBuilder().setX(argVec.x).setY(argVec.y).build();
    }
}

