/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.pooling.normal;

import java.lang.reflect.Array;

public class OrderedStack<E> {
    private final E[] pool;
    private int index;
    private final int size;
    private final E[] container;

    public OrderedStack(Class<E> argClass, int argStackSize, int argContainerSize) {
        this.size = argStackSize;
        this.pool = (Object[])Array.newInstance(argClass, argStackSize);
        int i = 0;
        while (i < argStackSize) {
            try {
                this.pool[i] = argClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating pooled object " + argClass.getSimpleName(), e);
            }
            ++i;
        }
        this.index = 0;
        this.container = (Object[])Array.newInstance(argClass, argContainerSize);
    }

    public final E pop() {
        assert (this.index < this.size) : "End of stack reached, there is probably a leak somewhere";
        return this.pool[this.index++];
    }

    public final E[] pop(int argNum) {
        assert (this.index + argNum < this.size) : "End of stack reached, there is probably a leak somewhere";
        assert (argNum <= this.container.length) : "Container array is too small";
        System.arraycopy(this.pool, this.index, this.container, 0, argNum);
        this.index += argNum;
        return this.container;
    }

    public final void push(int argNum) {
        this.index -= argNum;
        assert (this.index >= 0) : "Beginning of stack reached, push/pops are unmatched";
    }
}

