/*
 * Decompiled with CFR 0.152.
 */
package org.iforce2d;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.iforce2d.Jb2dJsonImage;
import org.jbox2d.collision.shapes.ChainShape;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.MassData;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Filter;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.DistanceJoint;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.FrictionJoint;
import org.jbox2d.dynamics.joints.FrictionJointDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.JointType;
import org.jbox2d.dynamics.joints.MouseJoint;
import org.jbox2d.dynamics.joints.MouseJointDef;
import org.jbox2d.dynamics.joints.PrismaticJoint;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.dynamics.joints.PulleyJoint;
import org.jbox2d.dynamics.joints.PulleyJointDef;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.dynamics.joints.RopeJoint;
import org.jbox2d.dynamics.joints.RopeJointDef;
import org.jbox2d.dynamics.joints.WeldJoint;
import org.jbox2d.dynamics.joints.WeldJointDef;
import org.jbox2d.dynamics.joints.WheelJoint;
import org.jbox2d.dynamics.joints.WheelJointDef;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Jb2dJson {
    protected boolean m_useHumanReadableFloats;
    protected int m_simulationPositionIterations;
    protected int m_simulationVelocityIterations;
    protected float m_simulationFPS;
    protected Map<Integer, Body> m_indexToBodyMap;
    protected Map<Body, Integer> m_bodyToIndexMap;
    protected Map<Joint, Integer> m_jointToIndexMap;
    protected Vector<Body> m_bodies;
    protected Vector<Joint> m_joints;
    protected Vector<Jb2dJsonImage> m_images;
    protected Map<Body, String> m_bodyToNameMap;
    protected Map<Fixture, String> m_fixtureToNameMap;
    protected Map<Joint, String> m_jointToNameMap;
    protected Map<Jb2dJsonImage, String> m_imageToNameMap;
    protected Map<Object, Jb2dJsonCustomProperties> m_customPropertiesMap;
    protected Set<Body> m_bodiesWithCustomProperties;
    protected Set<Fixture> m_fixturesWithCustomProperties;
    protected Set<Joint> m_jointsWithCustomProperties;
    protected Set<Jb2dJsonImage> m_imagesWithCustomProperties;
    protected Set<World> m_worldsWithCustomProperties;

    public Jb2dJson() {
        this(true);
    }

    public Jb2dJson(boolean useHumanReadableFloats) {
        if (!useHumanReadableFloats) {
            System.out.println("Non human readable floats are not implemented yet");
            useHumanReadableFloats = true;
        }
        this.m_useHumanReadableFloats = useHumanReadableFloats;
        this.m_simulationPositionIterations = 3;
        this.m_simulationVelocityIterations = 8;
        this.m_simulationFPS = 60.0f;
        this.m_indexToBodyMap = new HashMap<Integer, Body>();
        this.m_bodyToIndexMap = new HashMap<Body, Integer>();
        this.m_jointToIndexMap = new HashMap<Joint, Integer>();
        this.m_bodies = new Vector();
        this.m_joints = new Vector();
        this.m_images = new Vector();
        this.m_bodyToNameMap = new HashMap<Body, String>();
        this.m_fixtureToNameMap = new HashMap<Fixture, String>();
        this.m_jointToNameMap = new HashMap<Joint, String>();
        this.m_imageToNameMap = new HashMap<Jb2dJsonImage, String>();
        this.m_customPropertiesMap = new HashMap<Object, Jb2dJsonCustomProperties>();
        this.m_bodiesWithCustomProperties = new HashSet<Body>();
        this.m_fixturesWithCustomProperties = new HashSet<Fixture>();
        this.m_jointsWithCustomProperties = new HashSet<Joint>();
        this.m_imagesWithCustomProperties = new HashSet<Jb2dJsonImage>();
        this.m_worldsWithCustomProperties = new HashSet<World>();
    }

    public JSONObject writeToValue(World world) throws JSONException {
        if (world == null) {
            return new JSONObject();
        }
        return this.b2j(world);
    }

    public String worldToString(World world, int indentFactor) throws JSONException {
        if (world == null) {
            return new String();
        }
        return this.b2j(world).toString(indentFactor);
    }

    public boolean writeToFile(World world, String filename, int indentFactor, StringBuilder errorMsg) {
        PrintWriter writer;
        if (world == null || filename == null) {
            return false;
        }
        try {
            writer = new PrintWriter(filename);
        }
        catch (FileNotFoundException e) {
            errorMsg.append("Could not open file " + filename + "for writing");
            return false;
        }
        try {
            writer.println(this.b2j(world).toString(indentFactor));
        }
        catch (JSONException e) {
            errorMsg.append("Error writing JSON to file: " + filename);
        }
        writer.close();
        return true;
    }

    public JSONObject b2j(World world) throws JSONException {
        JSONObject worldValue = new JSONObject();
        this.m_bodyToIndexMap.clear();
        this.m_jointToIndexMap.clear();
        this.vecToJson("gravity", world.getGravity(), worldValue);
        worldValue.put("allowSleep", world.isAllowSleep());
        worldValue.put("autoClearForces", world.getAutoClearForces());
        worldValue.put("warmStarting", world.isWarmStarting());
        worldValue.put("continuousPhysics", world.isContinuousPhysics());
        JSONArray customPropertyValue = this.writeCustomPropertiesToJson(null);
        if (customPropertyValue.length() > 0) {
            worldValue.put("customProperties", customPropertyValue);
        }
        int i = 0;
        Body body = world.getBodyList();
        while (body != null) {
            this.m_bodyToIndexMap.put(body, i);
            worldValue.append("body", this.b2j(body));
            ++i;
            body = body.getNext();
        }
        i = 0;
        Joint joint = world.getJointList();
        while (joint != null) {
            if (joint.getType() != JointType.GEAR) {
                this.m_jointToIndexMap.put(joint, i);
                worldValue.append("joint", this.b2j(joint));
                ++i;
            }
            joint = joint.getNext();
        }
        joint = world.getJointList();
        while (joint != null) {
            if (joint.getType() == JointType.GEAR) {
                this.m_jointToIndexMap.put(joint, i);
                worldValue.append("joint", this.b2j(joint));
                ++i;
            }
            joint = joint.getNext();
        }
        i = 0;
        for (Jb2dJsonImage image : this.m_imageToNameMap.keySet()) {
            worldValue.append("image", this.b2j(image));
        }
        this.m_bodyToIndexMap.clear();
        this.m_jointToIndexMap.clear();
        return worldValue;
    }

    public void setBodyName(Body body, String name) {
        this.m_bodyToNameMap.put(body, name);
    }

    public void setFixtureName(Fixture fixture, String name) {
        this.m_fixtureToNameMap.put(fixture, name);
    }

    public void setJointName(Joint joint, String name) {
        this.m_jointToNameMap.put(joint, name);
    }

    public void setImageName(Jb2dJsonImage image, String name) {
        this.m_imageToNameMap.put(image, name);
    }

    public JSONObject b2j(Body body) throws JSONException {
        JSONObject bodyValue = new JSONObject();
        String bodyName = this.getBodyName(body);
        if (bodyName != null) {
            bodyValue.put("name", bodyName);
        }
        switch (body.getType()) {
            case STATIC: {
                bodyValue.put("type", 0);
                break;
            }
            case KINEMATIC: {
                bodyValue.put("type", 1);
                break;
            }
            case DYNAMIC: {
                bodyValue.put("type", 2);
            }
        }
        this.vecToJson("position", body.getPosition(), bodyValue);
        this.floatToJson("angle", body.getAngle(), bodyValue);
        this.vecToJson("linearVelocity", body.getLinearVelocity(), bodyValue);
        this.floatToJson("angularVelocity", body.getAngularVelocity(), bodyValue);
        if (body.getLinearDamping() != 0.0f) {
            this.floatToJson("linearDamping", body.getLinearDamping(), bodyValue);
        }
        if (body.getAngularDamping() != 0.0f) {
            this.floatToJson("angularDamping", body.getAngularDamping(), bodyValue);
        }
        if (body.getGravityScale() != 1.0f) {
            this.floatToJson("gravityScale", body.getGravityScale(), bodyValue);
        }
        if (body.isBullet()) {
            bodyValue.put("bullet", true);
        }
        if (!body.isSleepingAllowed()) {
            bodyValue.put("allowSleep", false);
        }
        if (body.isAwake()) {
            bodyValue.put("awake", true);
        }
        if (!body.isActive()) {
            bodyValue.put("active", false);
        }
        if (body.isFixedRotation()) {
            bodyValue.put("fixedRotation", true);
        }
        MassData massData = new MassData();
        body.getMassData(massData);
        if (massData.mass != 0.0f) {
            this.floatToJson("massData-mass", massData.mass, bodyValue);
        }
        if (massData.center.x != 0.0f || massData.center.y != 0.0f) {
            this.vecToJson("massData-center", massData.center, bodyValue);
        }
        if (massData.I != 0.0f) {
            this.floatToJson("massData-I", massData.I, bodyValue);
        }
        boolean i = false;
        Fixture fixture = body.getFixtureList();
        while (fixture != null) {
            bodyValue.append("fixture", this.b2j(fixture));
            fixture = fixture.getNext();
        }
        JSONArray customPropertyValue = this.writeCustomPropertiesToJson(body);
        if (customPropertyValue.length() > 0) {
            bodyValue.put("customProperties", customPropertyValue);
        }
        return bodyValue;
    }

    public JSONObject b2j(Fixture fixture) throws JSONException {
        JSONObject fixtureValue = new JSONObject();
        String fixtureName = this.getFixtureName(fixture);
        if (fixtureName != null) {
            fixtureValue.put("name", fixtureName);
        }
        if (fixture.getRestitution() != 0.0f) {
            this.floatToJson("restitution", fixture.getRestitution(), fixtureValue);
        }
        if (fixture.getFriction() != 0.0f) {
            this.floatToJson("friction", fixture.getFriction(), fixtureValue);
        }
        if (fixture.getDensity() != 0.0f) {
            this.floatToJson("density", fixture.getDensity(), fixtureValue);
        }
        if (fixture.isSensor()) {
            fixtureValue.put("sensor", true);
        }
        Filter filter = fixture.getFilterData();
        if (filter.categoryBits != 1) {
            fixtureValue.put("filter-categoryBits", filter.categoryBits);
        }
        if (filter.maskBits != 65535) {
            fixtureValue.put("filter-maskBits", filter.maskBits);
        }
        if (filter.groupIndex != 0) {
            fixtureValue.put("filter-groupIndex", filter.groupIndex);
        }
        Shape shape = fixture.getShape();
        switch (shape.getType()) {
            case CIRCLE: {
                CircleShape circle = (CircleShape)shape;
                JSONObject shapeValue = new JSONObject();
                this.floatToJson("radius", circle.m_radius, shapeValue);
                this.vecToJson("center", circle.m_p, shapeValue);
                fixtureValue.put("circle", shapeValue);
                break;
            }
            case EDGE: {
                EdgeShape edge = (EdgeShape)shape;
                JSONObject shapeValue = new JSONObject();
                this.vecToJson("vertex1", edge.m_vertex1, shapeValue);
                this.vecToJson("vertex2", edge.m_vertex2, shapeValue);
                if (edge.m_hasVertex0) {
                    shapeValue.put("hasVertex0", true);
                }
                if (edge.m_hasVertex3) {
                    shapeValue.put("hasVertex3", true);
                }
                if (edge.m_hasVertex0) {
                    this.vecToJson("vertex0", edge.m_vertex0, shapeValue);
                }
                if (edge.m_hasVertex3) {
                    this.vecToJson("vertex3", edge.m_vertex3, shapeValue);
                }
                fixtureValue.put("edge", shapeValue);
                break;
            }
            case CHAIN: {
                ChainShape chain = (ChainShape)shape;
                JSONObject shapeValue = new JSONObject();
                int count = chain.m_count;
                int i = 0;
                while (i < count) {
                    this.vecToJson("vertices", chain.m_vertices[i], shapeValue, i);
                    ++i;
                }
                if (chain.m_hasPrevVertex) {
                    shapeValue.put("hasPrevVertex", true);
                }
                if (chain.m_hasNextVertex) {
                    shapeValue.put("hasNextVertex", true);
                }
                if (chain.m_hasPrevVertex) {
                    this.vecToJson("prevVertex", chain.m_prevVertex, shapeValue);
                }
                if (chain.m_hasNextVertex) {
                    this.vecToJson("nextVertex", chain.m_nextVertex, shapeValue);
                }
                fixtureValue.put("chain", shapeValue);
                break;
            }
            case POLYGON: {
                PolygonShape poly = (PolygonShape)shape;
                JSONObject shapeValue = new JSONObject();
                int vertexCount = poly.getVertexCount();
                int i = 0;
                while (i < vertexCount) {
                    this.vecToJson("vertices", poly.m_vertices[i], shapeValue, i);
                    ++i;
                }
                fixtureValue.put("polygon", shapeValue);
                break;
            }
            default: {
                System.out.println("Unknown shape type : " + (Object)((Object)shape.getType()));
            }
        }
        JSONArray customPropertyValue = this.writeCustomPropertiesToJson(fixture);
        if (customPropertyValue.length() > 0) {
            fixtureValue.put("customProperties", customPropertyValue);
        }
        return fixtureValue;
    }

    public JSONObject b2j(Joint joint) throws JSONException {
        JSONObject jointValue = new JSONObject();
        String jointName = this.getJointName(joint);
        if (jointName != null) {
            jointValue.put("name", jointName);
        }
        int bodyIndexA = this.lookupBodyIndex(joint.getBodyA());
        int bodyIndexB = this.lookupBodyIndex(joint.getBodyB());
        jointValue.put("bodyA", bodyIndexA);
        jointValue.put("bodyB", bodyIndexB);
        if (joint.getCollideConnected()) {
            jointValue.put("collideConnected", true);
        }
        Body bodyA = joint.getBodyA();
        Body bodyB = joint.getBodyB();
        Vec2 tmpAnchor = new Vec2();
        switch (joint.getType()) {
            case REVOLUTE: {
                jointValue.put("type", "revolute");
                RevoluteJoint revoluteJoint = (RevoluteJoint)joint;
                revoluteJoint.getAnchorA(tmpAnchor);
                this.vecToJson("anchorA", bodyA.getLocalPoint(tmpAnchor), jointValue);
                revoluteJoint.getAnchorB(tmpAnchor);
                this.vecToJson("anchorB", bodyB.getLocalPoint(tmpAnchor), jointValue);
                this.floatToJson("refAngle", bodyB.getAngle() - bodyA.getAngle() - revoluteJoint.getJointAngle(), jointValue);
                this.floatToJson("jointSpeed", revoluteJoint.getJointSpeed(), jointValue);
                jointValue.put("enableLimit", revoluteJoint.isLimitEnabled());
                this.floatToJson("lowerLimit", revoluteJoint.getLowerLimit(), jointValue);
                this.floatToJson("upperLimit", revoluteJoint.getUpperLimit(), jointValue);
                jointValue.put("enableMotor", revoluteJoint.isMotorEnabled());
                this.floatToJson("motorSpeed", revoluteJoint.getMotorSpeed(), jointValue);
                this.floatToJson("maxMotorTorque", revoluteJoint.getMaxMotorTorque(), jointValue);
                break;
            }
            case PRISMATIC: {
                jointValue.put("type", "prismatic");
                PrismaticJoint prismaticJoint = (PrismaticJoint)joint;
                prismaticJoint.getAnchorA(tmpAnchor);
                this.vecToJson("anchorA", bodyA.getLocalPoint(tmpAnchor), jointValue);
                prismaticJoint.getAnchorB(tmpAnchor);
                this.vecToJson("anchorB", bodyB.getLocalPoint(tmpAnchor), jointValue);
                this.vecToJson("localAxisA", prismaticJoint.getLocalAxisA(), jointValue);
                this.floatToJson("refAngle", prismaticJoint.getReferenceAngle(), jointValue);
                jointValue.put("enableLimit", prismaticJoint.isLimitEnabled());
                this.floatToJson("lowerLimit", prismaticJoint.getLowerLimit(), jointValue);
                this.floatToJson("upperLimit", prismaticJoint.getUpperLimit(), jointValue);
                jointValue.put("enableMotor", prismaticJoint.isMotorEnabled());
                this.floatToJson("maxMotorForce", prismaticJoint.getMaxMotorForce(), jointValue);
                this.floatToJson("motorSpeed", prismaticJoint.getMotorSpeed(), jointValue);
                break;
            }
            case DISTANCE: {
                jointValue.put("type", "distance");
                DistanceJoint distanceJoint = (DistanceJoint)joint;
                distanceJoint.getAnchorA(tmpAnchor);
                this.vecToJson("anchorA", bodyA.getLocalPoint(tmpAnchor), jointValue);
                distanceJoint.getAnchorB(tmpAnchor);
                this.vecToJson("anchorB", bodyB.getLocalPoint(tmpAnchor), jointValue);
                this.floatToJson("length", distanceJoint.getLength(), jointValue);
                this.floatToJson("frequency", distanceJoint.getFrequency(), jointValue);
                this.floatToJson("dampingRatio", distanceJoint.getDampingRatio(), jointValue);
                break;
            }
            case PULLEY: {
                jointValue.put("type", "pulley");
                PulleyJoint pulleyJoint = (PulleyJoint)joint;
                this.vecToJson("groundAnchorA", pulleyJoint.getGroundAnchorA(), jointValue);
                this.vecToJson("groundAnchorB", pulleyJoint.getGroundAnchorB(), jointValue);
                pulleyJoint.getAnchorA(tmpAnchor);
                this.vecToJson("anchorA", bodyA.getLocalPoint(tmpAnchor), jointValue);
                this.floatToJson("lengthA", pulleyJoint.getGroundAnchorA().sub(tmpAnchor).length(), jointValue);
                pulleyJoint.getAnchorB(tmpAnchor);
                this.vecToJson("anchorB", bodyB.getLocalPoint(tmpAnchor), jointValue);
                this.floatToJson("lengthB", pulleyJoint.getGroundAnchorB().sub(tmpAnchor).length(), jointValue);
                this.floatToJson("ratio", pulleyJoint.getRatio(), jointValue);
                break;
            }
            case MOUSE: {
                jointValue.put("type", "mouse");
                MouseJoint mouseJoint = (MouseJoint)joint;
                this.vecToJson("target", mouseJoint.getTarget(), jointValue);
                mouseJoint.getAnchorB(tmpAnchor);
                this.vecToJson("anchorB", tmpAnchor, jointValue);
                this.floatToJson("maxForce", mouseJoint.getMaxForce(), jointValue);
                this.floatToJson("frequency", mouseJoint.getFrequency(), jointValue);
                this.floatToJson("dampingRatio", mouseJoint.getDampingRatio(), jointValue);
                break;
            }
            case GEAR: {
                break;
            }
            case WHEEL: {
                jointValue.put("type", "wheel");
                WheelJoint wheelJoint = (WheelJoint)joint;
                wheelJoint.getAnchorA(tmpAnchor);
                this.vecToJson("anchorA", bodyA.getLocalPoint(tmpAnchor), jointValue);
                wheelJoint.getAnchorB(tmpAnchor);
                this.vecToJson("anchorB", bodyB.getLocalPoint(tmpAnchor), jointValue);
                this.vecToJson("localAxisA", wheelJoint.getLocalAxisA(), jointValue);
                jointValue.put("enableMotor", wheelJoint.isMotorEnabled());
                this.floatToJson("motorSpeed", wheelJoint.getMotorSpeed(), jointValue);
                this.floatToJson("maxMotorTorque", wheelJoint.getMaxMotorTorque(), jointValue);
                this.floatToJson("springFrequency", wheelJoint.getSpringFrequencyHz(), jointValue);
                this.floatToJson("springDampingRatio", wheelJoint.getSpringDampingRatio(), jointValue);
                break;
            }
            case WELD: {
                jointValue.put("type", "weld");
                WeldJoint weldJoint = (WeldJoint)joint;
                weldJoint.getAnchorA(tmpAnchor);
                this.vecToJson("anchorA", bodyA.getLocalPoint(tmpAnchor), jointValue);
                weldJoint.getAnchorB(tmpAnchor);
                this.vecToJson("anchorB", bodyB.getLocalPoint(tmpAnchor), jointValue);
                this.floatToJson("refAngle", weldJoint.getReferenceAngle(), jointValue);
                break;
            }
            case FRICTION: {
                jointValue.put("type", "friction");
                FrictionJoint frictionJoint = (FrictionJoint)joint;
                frictionJoint.getAnchorA(tmpAnchor);
                this.vecToJson("anchorA", bodyA.getLocalPoint(tmpAnchor), jointValue);
                frictionJoint.getAnchorB(tmpAnchor);
                this.vecToJson("anchorB", bodyB.getLocalPoint(tmpAnchor), jointValue);
                this.floatToJson("maxForce", frictionJoint.getMaxForce(), jointValue);
                this.floatToJson("maxTorque", frictionJoint.getMaxTorque(), jointValue);
                break;
            }
            case ROPE: {
                jointValue.put("type", "rope");
                RopeJoint ropeJoint = (RopeJoint)joint;
                ropeJoint.getAnchorA(tmpAnchor);
                this.vecToJson("anchorA", bodyA.getLocalPoint(tmpAnchor), jointValue);
                ropeJoint.getAnchorB(tmpAnchor);
                this.vecToJson("anchorB", bodyB.getLocalPoint(tmpAnchor), jointValue);
                this.floatToJson("maxLength", ropeJoint.getMaxLength(), jointValue);
                break;
            }
            default: {
                System.out.println("Unknown joint type : " + (Object)((Object)joint.getType()));
            }
        }
        JSONArray customPropertyValue = this.writeCustomPropertiesToJson(joint);
        if (customPropertyValue.length() > 0) {
            jointValue.put("customProperties", customPropertyValue);
        }
        return jointValue;
    }

    JSONObject b2j(Jb2dJsonImage image) throws JSONException {
        JSONObject imageValue = new JSONObject();
        if (image.body != null) {
            imageValue.put("body", this.lookupBodyIndex(image.body));
        } else {
            imageValue.put("body", -1);
        }
        if (image.name != null) {
            imageValue.put("name", image.name);
        }
        if (image.file != null) {
            imageValue.put("file", image.file);
        }
        this.vecToJson("center", image.center, imageValue);
        this.floatToJson("angle", image.angle, imageValue);
        this.floatToJson("scale", image.scale, imageValue);
        if (image.flip) {
            imageValue.put("flip", true);
        }
        this.floatToJson("opacity", image.opacity, imageValue);
        imageValue.put("filter", image.filter);
        this.floatToJson("renderOrder", image.renderOrder, imageValue);
        boolean defaultColorTint = true;
        int i = 0;
        while (i < 4) {
            if (image.colorTint[i] != 255) {
                defaultColorTint = false;
                break;
            }
            ++i;
        }
        if (!defaultColorTint) {
            JSONArray array = imageValue.getJSONArray("colorTint");
            int i2 = 0;
            while (i2 < 4) {
                array.put(i2, image.colorTint[i2]);
                ++i2;
            }
        }
        i = 0;
        while (i < 4) {
            this.vecToJson("corners", image.corners[i], imageValue, i);
            ++i;
        }
        i = 0;
        while (i < 2 * image.numPoints) {
            this.vecToJson("glVertexPointer", image.points[i], imageValue, i);
            this.vecToJson("glTexCoordPointer", image.uvCoords[i], imageValue, i);
            ++i;
        }
        i = 0;
        while (i < image.numIndices) {
            this.vecToJson("glDrawElements", image.indices[i], imageValue, i);
            ++i;
        }
        JSONArray customPropertyValue = this.writeCustomPropertiesToJson(image);
        if (customPropertyValue.length() > 0) {
            imageValue.put("customProperties", customPropertyValue);
        }
        return imageValue;
    }

    Body lookupBodyFromIndex(int index) {
        if (this.m_indexToBodyMap.containsKey(index)) {
            return this.m_indexToBodyMap.get(index);
        }
        return null;
    }

    protected int lookupBodyIndex(Body body) {
        Integer val = this.m_bodyToIndexMap.get(body);
        if (val != null) {
            return val;
        }
        return -1;
    }

    protected int lookupJointIndex(Joint joint) {
        Integer val = this.m_jointToIndexMap.get(joint);
        if (val != null) {
            return val;
        }
        return -1;
    }

    public String getBodyName(Body body) {
        return this.m_bodyToNameMap.get(body);
    }

    public String getFixtureName(Fixture fixture) {
        return this.m_fixtureToNameMap.get(fixture);
    }

    public String getJointName(Joint joint) {
        return this.m_jointToNameMap.get(joint);
    }

    public String getImageName(Jb2dJsonImage image) {
        return this.m_imageToNameMap.get(image);
    }

    public String floatToHex(float f) {
        int bits = Float.floatToIntBits(f);
        return Integer.toHexString(bits);
    }

    public void floatToJson(String name, float f, JSONObject value) throws JSONException {
        if (f == 0.0f) {
            value.put(name, 0);
        } else if (f == 1.0f) {
            value.put(name, 1);
        } else if (this.m_useHumanReadableFloats) {
            value.put(name, f);
        } else {
            value.put(name, this.floatToHex(f));
        }
    }

    public void vecToJson(String name, int v, JSONObject value, int index) throws JSONException {
        if (index > -1) {
            JSONArray array = value.getJSONArray(name);
            array.put(index, v);
        } else {
            value.put(name, v);
        }
    }

    public void vecToJson(String name, float v, JSONObject value, int index) throws JSONException {
        if (index > -1) {
            if (this.m_useHumanReadableFloats) {
                JSONArray array = value.getJSONArray(name);
                array.put(index, v);
            } else {
                JSONArray array = value.getJSONArray(name);
                if (v == 0.0f) {
                    array.put(index, 0);
                } else if (v == 1.0f) {
                    array.put(index, 1);
                } else {
                    array.put(index, this.floatToHex(v));
                }
            }
        } else {
            this.floatToJson(name, v, value);
        }
    }

    public void vecToJson(String name, Vec2 vec, JSONObject value) throws JSONException {
        this.vecToJson(name, vec, value, -1);
    }

    public void vecToJson(String name, Vec2 vec, JSONObject value, int index) throws JSONException {
        if (index > -1) {
            if (this.m_useHumanReadableFloats) {
                boolean alreadyHadArray = value.has(name);
                JSONArray arrayX = alreadyHadArray ? value.getJSONObject(name).getJSONArray("x") : new JSONArray();
                JSONArray arrayY = alreadyHadArray ? value.getJSONObject(name).getJSONArray("y") : new JSONArray();
                arrayX.put(index, vec.x);
                arrayY.put(index, vec.y);
                if (!alreadyHadArray) {
                    JSONObject subValue = new JSONObject();
                    subValue.put("x", arrayX);
                    subValue.put("y", arrayY);
                    value.put(name, subValue);
                }
            } else {
                JSONArray arrayY;
                boolean alreadyHadArray = value.has(name);
                JSONArray arrayX = alreadyHadArray ? value.getJSONObject(name).getJSONArray("x") : new JSONArray();
                JSONArray jSONArray = arrayY = alreadyHadArray ? value.getJSONObject(name).getJSONArray("y") : new JSONArray();
                if (vec.x == 0.0f) {
                    arrayX.put(index, 0);
                } else if (vec.x == 1.0f) {
                    arrayX.put(index, 1);
                } else {
                    arrayX.put(index, this.floatToHex(vec.x));
                }
                if (vec.y == 0.0f) {
                    arrayY.put(index, 0);
                } else if (vec.y == 1.0f) {
                    arrayY.put(index, 1);
                } else {
                    arrayY.put(index, this.floatToHex(vec.y));
                }
                if (!alreadyHadArray) {
                    JSONObject subValue = new JSONObject();
                    subValue.put("x", arrayX);
                    subValue.put("y", arrayY);
                    value.put(name, subValue);
                }
            }
        } else if (vec.x == 0.0f && vec.y == 0.0f) {
            value.put(name, 0);
        } else {
            JSONObject vecValue = new JSONObject();
            this.floatToJson("x", vec.x, vecValue);
            this.floatToJson("y", vec.y, vecValue);
            value.put(name, vecValue);
        }
    }

    public void clear() {
        this.m_indexToBodyMap.clear();
        this.m_bodyToIndexMap.clear();
        this.m_jointToIndexMap.clear();
        this.m_bodies.clear();
        this.m_joints.clear();
        this.m_images.clear();
        this.m_bodyToNameMap.clear();
        this.m_fixtureToNameMap.clear();
        this.m_jointToNameMap.clear();
        this.m_imageToNameMap.clear();
    }

    public World readFromJSONObject(JSONObject worldValue) throws JSONException {
        this.clear();
        return this.j2b2World(worldValue);
    }

    public World readFromString(String str, StringBuilder errorMsg) {
        try {
            JSONObject worldValue = new JSONObject(str);
            return this.j2b2World(worldValue);
        }
        catch (JSONException e) {
            errorMsg.append("Failed to parse JSON");
            e.printStackTrace();
            return null;
        }
    }

    public World readFromFile(String filename, StringBuilder errorMsg) {
        if (filename == null) {
            return null;
        }
        String str = new String();
        try {
            String line;
            FileInputStream fis = new FileInputStream(filename);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, Charset.forName("UTF-8")));
            while ((line = br.readLine()) != null) {
                str = String.valueOf(str) + line;
            }
        }
        catch (FileNotFoundException e) {
            errorMsg.append("Could not open file for reading: " + filename);
            return null;
        }
        catch (IOException e) {
            errorMsg.append("Error reading file: " + filename);
            return null;
        }
        try {
            JSONObject worldValue = new JSONObject(str);
            return this.j2b2World(worldValue);
        }
        catch (JSONException e) {
            errorMsg.append("\nFailed to parse JSON: " + filename);
            e.printStackTrace();
            return null;
        }
    }

    public World j2b2World(JSONObject worldValue) throws JSONException {
        JSONArray jointValues;
        World world = new World(this.jsonToVec("gravity", worldValue));
        world.setAllowSleep(worldValue.getBoolean("allowSleep"));
        world.setAutoClearForces(worldValue.getBoolean("autoClearForces"));
        world.setWarmStarting(worldValue.getBoolean("warmStarting"));
        world.setContinuousPhysics(worldValue.getBoolean("continuousPhysics"));
        this.readCustomPropertiesFromJson(world, worldValue);
        int i = 0;
        JSONArray bodyValues = worldValue.optJSONArray("body");
        if (bodyValues != null) {
            int numBodyValues = bodyValues.length();
            i = 0;
            while (i < numBodyValues) {
                JSONObject bodyValue = bodyValues.getJSONObject(i);
                Body body = this.j2b2Body(world, bodyValue);
                this.readCustomPropertiesFromJson(body, bodyValue);
                this.m_bodies.add(body);
                this.m_indexToBodyMap.put(i, body);
                ++i;
            }
        }
        if ((jointValues = worldValue.optJSONArray("joint")) != null) {
            Joint joint;
            JSONObject jointValue;
            int numJointValues = jointValues.length();
            i = 0;
            while (i < numJointValues) {
                jointValue = jointValues.getJSONObject(i);
                if (!jointValue.optString("type", "").equals("gear")) {
                    joint = this.j2b2Joint(world, jointValue);
                    this.readCustomPropertiesFromJson(joint, jointValue);
                    this.m_joints.add(joint);
                }
                ++i;
            }
            i = 0;
            while (i < numJointValues) {
                jointValue = jointValues.getJSONObject(i);
                if (jointValue.optString("type", "").equals("gear")) {
                    joint = this.j2b2Joint(world, jointValue);
                    this.readCustomPropertiesFromJson(joint, jointValue);
                    this.m_joints.add(joint);
                }
                ++i;
            }
        }
        i = 0;
        JSONArray imageValues = worldValue.optJSONArray("image");
        if (imageValues != null) {
            int numImageValues = imageValues.length();
            i = 0;
            while (i < numImageValues) {
                JSONObject imageValue = imageValues.getJSONObject(i);
                Jb2dJsonImage image = this.j2b2dJsonImage(imageValue);
                this.readCustomPropertiesFromJson(image, imageValue);
                this.m_images.add(image);
                ++i;
            }
        }
        return world;
    }

    public Body j2b2Body(World world, JSONObject bodyValue) throws JSONException {
        BodyDef bodyDef = new BodyDef();
        switch (bodyValue.getInt("type")) {
            case 0: {
                bodyDef.type = BodyType.STATIC;
                break;
            }
            case 1: {
                bodyDef.type = BodyType.KINEMATIC;
                break;
            }
            case 2: {
                bodyDef.type = BodyType.DYNAMIC;
            }
        }
        bodyDef.position = this.jsonToVec("position", bodyValue);
        bodyDef.angle = this.jsonToFloat("angle", bodyValue);
        bodyDef.linearVelocity = this.jsonToVec("linearVelocity", bodyValue);
        bodyDef.angularVelocity = this.jsonToFloat("angularVelocity", bodyValue);
        bodyDef.linearDamping = this.jsonToFloat("linearDamping", bodyValue, -1, 0.0f);
        bodyDef.angularDamping = this.jsonToFloat("angularDamping", bodyValue, -1, 0.0f);
        bodyDef.gravityScale = this.jsonToFloat("gravityScale", bodyValue, -1, 1.0f);
        bodyDef.allowSleep = bodyValue.optBoolean("allowSleep", true);
        bodyDef.awake = bodyValue.optBoolean("awake", false);
        bodyDef.fixedRotation = bodyValue.optBoolean("fixedRotation");
        bodyDef.bullet = bodyValue.optBoolean("bullet", false);
        bodyDef.active = bodyValue.optBoolean("active", true);
        Body body = world.createBody(bodyDef);
        String bodyName = bodyValue.optString("name", "");
        if ("" != bodyName) {
            this.setBodyName(body, bodyName);
        }
        int i = 0;
        JSONArray fixtureValues = bodyValue.optJSONArray("fixture");
        if (fixtureValues != null) {
            int numFixtureValues = fixtureValues.length();
            i = 0;
            while (i < numFixtureValues) {
                JSONObject fixtureValue = fixtureValues.getJSONObject(i);
                Fixture fixture = this.j2b2Fixture(body, fixtureValue);
                this.readCustomPropertiesFromJson(fixture, fixtureValue);
                ++i;
            }
        }
        MassData massData = new MassData();
        massData.mass = this.jsonToFloat("massData-mass", bodyValue);
        massData.center.set(this.jsonToVec("massData-center", bodyValue));
        massData.I = this.jsonToFloat("massData-I", bodyValue);
        body.setMassData(massData);
        return body;
    }

    Fixture j2b2Fixture(Body body, JSONObject fixtureValue) throws JSONException {
        JSONObject chainValue;
        if (fixtureValue == null) {
            return null;
        }
        FixtureDef fixtureDef = new FixtureDef();
        fixtureDef.restitution = this.jsonToFloat("restitution", fixtureValue);
        fixtureDef.friction = this.jsonToFloat("friction", fixtureValue);
        fixtureDef.density = this.jsonToFloat("density", fixtureValue);
        fixtureDef.isSensor = fixtureValue.optBoolean("sensor", false);
        fixtureDef.filter.categoryBits = fixtureValue.optInt("filter-categoryBits", 1);
        fixtureDef.filter.maskBits = fixtureValue.optInt("filter-maskBits", 65535);
        fixtureDef.filter.groupIndex = fixtureValue.optInt("filter-groupIndex", 0);
        Fixture fixture = null;
        if (fixtureValue.optJSONObject("circle") != null) {
            JSONObject circleValue = fixtureValue.getJSONObject("circle");
            CircleShape circleShape = new CircleShape();
            circleShape.m_radius = this.jsonToFloat("radius", circleValue);
            circleShape.m_p.set(this.jsonToVec("center", circleValue));
            fixtureDef.shape = circleShape;
            fixture = body.createFixture(fixtureDef);
        } else if (fixtureValue.optJSONObject("edge") != null) {
            JSONObject edgeValue = fixtureValue.getJSONObject("edge");
            EdgeShape edgeShape = new EdgeShape();
            edgeShape.m_vertex1.set(this.jsonToVec("vertex1", edgeValue));
            edgeShape.m_vertex2.set(this.jsonToVec("vertex2", edgeValue));
            edgeShape.m_hasVertex0 = edgeValue.optBoolean("hasVertex0", false);
            edgeShape.m_hasVertex3 = edgeValue.optBoolean("hasVertex3", false);
            if (edgeShape.m_hasVertex0) {
                edgeShape.m_vertex0.set(this.jsonToVec("vertex0", edgeValue));
            }
            if (edgeShape.m_hasVertex3) {
                edgeShape.m_vertex3.set(this.jsonToVec("vertex3", edgeValue));
            }
            fixtureDef.shape = edgeShape;
            fixture = body.createFixture(fixtureDef);
        } else if (fixtureValue.optJSONObject("loop") != null) {
            chainValue = fixtureValue.getJSONObject("loop");
            ChainShape chainShape = new ChainShape();
            int numVertices = chainValue.getJSONArray("x").length();
            Vec2[] vertices = new Vec2[numVertices];
            int i = 0;
            while (i < numVertices) {
                vertices[i].set(this.jsonToVec("vertices", chainValue, i));
                ++i;
            }
            chainShape.createLoop(vertices, numVertices);
            fixtureDef.shape = chainShape;
            fixture = body.createFixture(fixtureDef);
        } else if (fixtureValue.optJSONObject("chain") != null) {
            chainValue = fixtureValue.getJSONObject("chain");
            ChainShape chainShape = new ChainShape();
            int numVertices = chainValue.getJSONObject("vertices").getJSONArray("x").length();
            Vec2[] vertices = new Vec2[numVertices];
            int i = 0;
            while (i < numVertices) {
                vertices[i] = this.jsonToVec("vertices", chainValue, i);
                ++i;
            }
            chainShape.createChain(vertices, numVertices);
            chainShape.m_hasPrevVertex = chainValue.optBoolean("hasPrevVertex", false);
            chainShape.m_hasNextVertex = chainValue.optBoolean("hasNextVertex", false);
            if (chainShape.m_hasPrevVertex) {
                chainShape.m_prevVertex.set(this.jsonToVec("prevVertex", chainValue));
            }
            if (chainShape.m_hasNextVertex) {
                chainShape.m_nextVertex.set(this.jsonToVec("nextVertex", chainValue));
            }
            fixtureDef.shape = chainShape;
            fixture = body.createFixture(fixtureDef);
        } else if (fixtureValue.optJSONObject("polygon") != null) {
            JSONObject polygonValue = fixtureValue.getJSONObject("polygon");
            Vec2[] vertices = new Vec2[8];
            int numVertices = polygonValue.getJSONObject("vertices").getJSONArray("x").length();
            if (numVertices > 8) {
                System.out.println("Ignoring polygon fixture with too many vertices.");
            } else if (numVertices < 2) {
                System.out.println("Ignoring polygon fixture less than two vertices.");
            } else if (numVertices == 2) {
                System.out.println("Creating edge shape instead of polygon with two vertices.");
                EdgeShape edgeShape = new EdgeShape();
                edgeShape.m_vertex1.set(this.jsonToVec("vertices", polygonValue, 0));
                edgeShape.m_vertex2.set(this.jsonToVec("vertices", polygonValue, 1));
                fixtureDef.shape = edgeShape;
                fixture = body.createFixture(fixtureDef);
            } else {
                PolygonShape polygonShape = new PolygonShape();
                int i = 0;
                while (i < numVertices) {
                    vertices[i] = this.jsonToVec("vertices", polygonValue, i);
                    ++i;
                }
                polygonShape.set(vertices, numVertices);
                fixtureDef.shape = polygonShape;
                fixture = body.createFixture(fixtureDef);
            }
        }
        String fixtureName = fixtureValue.optString("name", "");
        if (fixtureName != "") {
            this.setFixtureName(fixture, fixtureName);
        }
        return fixture;
    }

    Joint j2b2Joint(World world, JSONObject jointValue) throws JSONException {
        Joint joint = null;
        int bodyIndexA = jointValue.getInt("bodyA");
        int bodyIndexB = jointValue.getInt("bodyB");
        if (bodyIndexA >= this.m_bodies.size() || bodyIndexB >= this.m_bodies.size()) {
            return null;
        }
        JointDef jointDef = null;
        Vec2 mouseJointTarget = new Vec2(0.0f, 0.0f);
        String type = jointValue.optString("type", "");
        if (type.equals("revolute")) {
            RevoluteJointDef revoluteDef;
            jointDef = revoluteDef = new RevoluteJointDef();
            revoluteDef.localAnchorA = this.jsonToVec("anchorA", jointValue);
            revoluteDef.localAnchorB = this.jsonToVec("anchorB", jointValue);
            revoluteDef.referenceAngle = this.jsonToFloat("refAngle", jointValue);
            revoluteDef.enableLimit = jointValue.optBoolean("enableLimit", false);
            revoluteDef.lowerAngle = this.jsonToFloat("lowerLimit", jointValue);
            revoluteDef.upperAngle = this.jsonToFloat("upperLimit", jointValue);
            revoluteDef.enableMotor = jointValue.optBoolean("enableMotor", false);
            revoluteDef.motorSpeed = this.jsonToFloat("motorSpeed", jointValue);
            revoluteDef.maxMotorTorque = this.jsonToFloat("maxMotorTorque", jointValue);
        } else if (type.equals("prismatic")) {
            PrismaticJointDef prismaticDef = new PrismaticJointDef();
            jointDef = prismaticDef;
            prismaticDef.localAnchorA.set(this.jsonToVec("anchorA", jointValue));
            prismaticDef.localAnchorB.set(this.jsonToVec("anchorB", jointValue));
            if (jointValue.has("localAxisA")) {
                prismaticDef.localAxisA.set(this.jsonToVec("localAxisA", jointValue));
            } else {
                prismaticDef.localAxisA.set(this.jsonToVec("localAxis1", jointValue));
            }
            prismaticDef.referenceAngle = this.jsonToFloat("refAngle", jointValue);
            prismaticDef.enableLimit = jointValue.optBoolean("enableLimit");
            prismaticDef.lowerTranslation = this.jsonToFloat("lowerLimit", jointValue);
            prismaticDef.upperTranslation = this.jsonToFloat("upperLimit", jointValue);
            prismaticDef.enableMotor = jointValue.optBoolean("enableMotor");
            prismaticDef.motorSpeed = this.jsonToFloat("motorSpeed", jointValue);
            prismaticDef.maxMotorForce = this.jsonToFloat("maxMotorForce", jointValue);
        } else if (type.equals("distance")) {
            DistanceJointDef distanceDef = new DistanceJointDef();
            jointDef = distanceDef;
            distanceDef.localAnchorA.set(this.jsonToVec("anchorA", jointValue));
            distanceDef.localAnchorB.set(this.jsonToVec("anchorB", jointValue));
            distanceDef.length = this.jsonToFloat("length", jointValue);
            distanceDef.frequencyHz = this.jsonToFloat("frequency", jointValue);
            distanceDef.dampingRatio = this.jsonToFloat("dampingRatio", jointValue);
        } else if (type.equals("pulley")) {
            PulleyJointDef pulleyDef = new PulleyJointDef();
            jointDef = pulleyDef;
            pulleyDef.groundAnchorA.set(this.jsonToVec("groundAnchorA", jointValue));
            pulleyDef.groundAnchorB.set(this.jsonToVec("groundAnchorB", jointValue));
            pulleyDef.localAnchorA.set(this.jsonToVec("anchorA", jointValue));
            pulleyDef.localAnchorB.set(this.jsonToVec("anchorB", jointValue));
            pulleyDef.lengthA = this.jsonToFloat("lengthA", jointValue);
            pulleyDef.lengthB = this.jsonToFloat("lengthB", jointValue);
            pulleyDef.ratio = this.jsonToFloat("ratio", jointValue);
        } else if (type.equals("mouse")) {
            MouseJointDef mouseDef = new MouseJointDef();
            jointDef = mouseDef;
            mouseJointTarget = this.jsonToVec("target", jointValue);
            mouseDef.target.set(this.jsonToVec("anchorB", jointValue));
            mouseDef.maxForce = this.jsonToFloat("maxForce", jointValue);
            mouseDef.frequencyHz = this.jsonToFloat("frequency", jointValue);
            mouseDef.dampingRatio = this.jsonToFloat("dampingRatio", jointValue);
        } else if (type.equals("wheel")) {
            WheelJointDef wheelDef = new WheelJointDef();
            jointDef = wheelDef;
            wheelDef.localAnchorA.set(this.jsonToVec("anchorA", jointValue));
            wheelDef.localAnchorB.set(this.jsonToVec("anchorB", jointValue));
            wheelDef.localAxisA.set(this.jsonToVec("localAxisA", jointValue));
            wheelDef.enableMotor = jointValue.optBoolean("enableMotor", false);
            wheelDef.motorSpeed = this.jsonToFloat("motorSpeed", jointValue);
            wheelDef.maxMotorTorque = this.jsonToFloat("maxMotorTorque", jointValue);
            wheelDef.frequencyHz = this.jsonToFloat("springFrequency", jointValue);
            wheelDef.dampingRatio = this.jsonToFloat("springDampingRatio", jointValue);
        } else if (type.equals("weld")) {
            WeldJointDef weldDef = new WeldJointDef();
            jointDef = weldDef;
            weldDef.localAnchorA.set(this.jsonToVec("anchorA", jointValue));
            weldDef.localAnchorB.set(this.jsonToVec("anchorB", jointValue));
            weldDef.referenceAngle = 0.0f;
        } else if (type.equals("friction")) {
            FrictionJointDef frictionDef = new FrictionJointDef();
            jointDef = frictionDef;
            frictionDef.localAnchorA.set(this.jsonToVec("anchorA", jointValue));
            frictionDef.localAnchorB.set(this.jsonToVec("anchorB", jointValue));
            frictionDef.maxForce = this.jsonToFloat("maxForce", jointValue);
            frictionDef.maxTorque = this.jsonToFloat("maxTorque", jointValue);
        } else if (type.equals("rope")) {
            RopeJointDef ropeDef = new RopeJointDef();
            jointDef = ropeDef;
            ropeDef.localAnchorA.set(this.jsonToVec("anchorA", jointValue));
            ropeDef.localAnchorB.set(this.jsonToVec("anchorB", jointValue));
            ropeDef.maxLength = this.jsonToFloat("maxLength", jointValue);
        }
        if (jointDef != null) {
            String jointName;
            jointDef.bodyA = this.m_bodies.get(bodyIndexA);
            jointDef.bodyB = this.m_bodies.get(bodyIndexB);
            jointDef.collideConnected = jointValue.optBoolean("collideConnected", false);
            joint = world.createJoint(jointDef);
            if (type.equals("mouse")) {
                ((MouseJoint)joint).setTarget(mouseJointTarget);
            }
            if (!(jointName = jointValue.optString("name", "")).equals("")) {
                this.setJointName(joint, jointName);
            }
        }
        return joint;
    }

    Jb2dJsonImage j2b2dJsonImage(JSONObject imageValue) throws JSONException {
        JSONArray drawElementsArray;
        int i;
        int i2;
        String fileName;
        String imageName;
        Jb2dJsonImage img = new Jb2dJsonImage();
        int bodyIndex = imageValue.optInt("body", -1);
        if (-1 != bodyIndex) {
            img.body = this.lookupBodyFromIndex(bodyIndex);
        }
        if (!(imageName = imageValue.optString("name", "")).equals("")) {
            img.name = imageName;
            this.setImageName(img, imageName);
        }
        if (!(fileName = imageValue.optString("file", "")).equals("")) {
            img.file = fileName;
        }
        img.center = this.jsonToVec("center", imageValue);
        img.angle = this.jsonToFloat("angle", imageValue);
        img.scale = this.jsonToFloat("scale", imageValue);
        img.opacity = this.jsonToFloat("opacity", imageValue);
        img.renderOrder = this.jsonToFloat("renderOrder", imageValue);
        JSONArray colorTintArray = imageValue.optJSONArray("colorTint");
        if (colorTintArray != null) {
            i2 = 0;
            while (i2 < 4) {
                img.colorTint[i2] = colorTintArray.getInt(i2);
                ++i2;
            }
        }
        img.flip = imageValue.optBoolean("flip", false);
        img.filter = imageValue.optInt("filter", 1);
        img.corners = new Vec2[4];
        i2 = 0;
        while (i2 < 4) {
            img.corners[i2] = this.jsonToVec("corners", imageValue, i2);
            ++i2;
        }
        JSONArray vertexPointerArray = imageValue.optJSONArray("glVertexPointer");
        JSONArray texCoordArray = imageValue.optJSONArray("glVertexPointer");
        if (vertexPointerArray != null && texCoordArray != null && vertexPointerArray.length() == texCoordArray.length()) {
            int numFloats = vertexPointerArray.length();
            img.numPoints = numFloats / 2;
            img.points = new float[numFloats];
            img.uvCoords = new float[numFloats];
            i = 0;
            while (i < numFloats) {
                img.points[i] = this.jsonToFloat("glVertexPointer", imageValue, i);
                img.uvCoords[i] = this.jsonToFloat("glTexCoordPointer", imageValue, i);
                ++i;
            }
        }
        if ((drawElementsArray = imageValue.optJSONArray("glDrawElements")) != null) {
            img.numIndices = drawElementsArray.length();
            img.indices = new short[img.numIndices];
            i = 0;
            while (i < img.numIndices) {
                img.indices[i] = (short)drawElementsArray.getInt(i);
                ++i;
            }
        }
        return img;
    }

    float jsonToFloat(String name, JSONObject value) {
        return this.jsonToFloat(name, value, -1, 0.0f);
    }

    float jsonToFloat(String name, JSONObject value, int index) {
        return this.jsonToFloat(name, value, index, 0.0f);
    }

    float jsonToFloat(String name, JSONObject value, int index, float defaultValue) {
        if (!value.has(name)) {
            return defaultValue;
        }
        if (index > -1) {
            JSONArray array = null;
            try {
                array = value.getJSONArray(name);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (array == null) {
                return defaultValue;
            }
            Object obj = array.opt(index);
            if (obj == null) {
                return defaultValue;
            }
            return ((Number)obj).floatValue();
        }
        Object obj = value.opt(name);
        if (obj == null) {
            return defaultValue;
        }
        return ((Number)obj).floatValue();
    }

    Vec2 jsonToVec(String name, JSONObject value) throws JSONException {
        return this.jsonToVec(name, value, -1, new Vec2(0.0f, 0.0f));
    }

    Vec2 jsonToVec(String name, JSONObject value, int index) throws JSONException {
        return this.jsonToVec(name, value, index, new Vec2(0.0f, 0.0f));
    }

    Vec2 jsonToVec(String name, JSONObject value, int index, Vec2 defaultValue) throws JSONException {
        Vec2 vec = defaultValue;
        if (!value.has(name)) {
            return defaultValue;
        }
        if (index > -1) {
            JSONObject vecValue = value.getJSONObject(name);
            JSONArray arrayX = vecValue.getJSONArray("x");
            JSONArray arrayY = vecValue.getJSONArray("y");
            vec.x = (float)arrayX.getDouble(index);
            vec.y = (float)arrayY.getDouble(index);
        } else {
            JSONObject vecValue = value.optJSONObject(name);
            if (vecValue == null) {
                return defaultValue;
            }
            if (!vecValue.has("x")) {
                vec.set(0.0f, 0.0f);
            } else {
                vec.x = this.jsonToFloat("x", vecValue);
                vec.y = this.jsonToFloat("y", vecValue);
            }
        }
        return vec;
    }

    public Body[] getBodiesByName(String name) {
        HashSet<Body> keys = new HashSet<Body>();
        for (Map.Entry<Body, String> entry : this.m_bodyToNameMap.entrySet()) {
            if (!name.equals(entry.getValue())) continue;
            keys.add(entry.getKey());
        }
        return keys.toArray(new Body[0]);
    }

    public Fixture[] getFixturesByName(String name) {
        HashSet<Fixture> keys = new HashSet<Fixture>();
        for (Map.Entry<Fixture, String> entry : this.m_fixtureToNameMap.entrySet()) {
            if (!name.equals(entry.getValue())) continue;
            keys.add(entry.getKey());
        }
        return keys.toArray(new Fixture[0]);
    }

    public Joint[] getJointsByName(String name) {
        HashSet<Joint> keys = new HashSet<Joint>();
        for (Map.Entry<Joint, String> entry : this.m_jointToNameMap.entrySet()) {
            if (!name.equals(entry.getValue())) continue;
            keys.add(entry.getKey());
        }
        return keys.toArray(new Joint[0]);
    }

    public Jb2dJsonImage[] getImagesByName(String name) {
        HashSet<Jb2dJsonImage> keys = new HashSet<Jb2dJsonImage>();
        for (Map.Entry<Jb2dJsonImage, String> entry : this.m_imageToNameMap.entrySet()) {
            if (!name.equals(entry.getValue())) continue;
            keys.add(entry.getKey());
        }
        return keys.toArray(new Jb2dJsonImage[0]);
    }

    public Jb2dJsonImage[] getAllImages() {
        return (Jb2dJsonImage[])this.m_images.toArray();
    }

    public Body getBodyByName(String name) {
        for (Map.Entry<Body, String> entry : this.m_bodyToNameMap.entrySet()) {
            if (!name.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public Fixture getFixtureByName(String name) {
        for (Map.Entry<Fixture, String> entry : this.m_fixtureToNameMap.entrySet()) {
            if (!name.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public Joint getJointByName(String name) {
        for (Map.Entry<Joint, String> entry : this.m_jointToNameMap.entrySet()) {
            if (!name.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public Jb2dJsonImage getImageByName(String name) {
        for (Map.Entry<Jb2dJsonImage, String> entry : this.m_imageToNameMap.entrySet()) {
            if (!name.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public Jb2dJsonCustomProperties getCustomPropertiesForItem(Object item, boolean createIfNotExisting) {
        if (this.m_customPropertiesMap.containsKey(item)) {
            return this.m_customPropertiesMap.get(item);
        }
        if (!createIfNotExisting) {
            return null;
        }
        Jb2dJsonCustomProperties props = new Jb2dJsonCustomProperties();
        this.m_customPropertiesMap.put(item, props);
        return props;
    }

    protected void setCustomInt(Object item, String propertyName, int val) {
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_int.put(propertyName, val);
    }

    protected void setCustomFloat(Object item, String propertyName, float val) {
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_float.put(propertyName, new Double(val));
    }

    protected void setCustomString(Object item, String propertyName, String val) {
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_string.put(propertyName, val);
    }

    protected void setCustomVector(Object item, String propertyName, Vec2 val) {
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_vec2.put(propertyName, val);
    }

    protected void setCustomBool(Object item, String propertyName, boolean val) {
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_bool.put(propertyName, val);
    }

    public void setCustomInt(Body item, String propertyName, int val) {
        this.m_bodiesWithCustomProperties.add(item);
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_int.put(propertyName, val);
    }

    public void setCustomFloat(Body item, String propertyName, float val) {
        this.m_bodiesWithCustomProperties.add(item);
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_float.put(propertyName, new Double(val));
    }

    public void setCustomString(Body item, String propertyName, String val) {
        this.m_bodiesWithCustomProperties.add(item);
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_string.put(propertyName, val);
    }

    public void setCustomVector(Body item, String propertyName, Vec2 val) {
        this.m_bodiesWithCustomProperties.add(item);
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_vec2.put(propertyName, val);
    }

    public void setCustomBool(Body item, String propertyName, boolean val) {
        this.m_bodiesWithCustomProperties.add(item);
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_bool.put(propertyName, val);
    }

    public void setCustomInt(Fixture item, String propertyName, int val) {
        this.m_fixturesWithCustomProperties.add(item);
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_int.put(propertyName, val);
    }

    public void setCustomFloat(Fixture item, String propertyName, float val) {
        this.m_fixturesWithCustomProperties.add(item);
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_float.put(propertyName, new Double(val));
    }

    public void setCustomString(Fixture item, String propertyName, String val) {
        this.m_fixturesWithCustomProperties.add(item);
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_string.put(propertyName, val);
    }

    public void setCustomVector(Fixture item, String propertyName, Vec2 val) {
        this.m_fixturesWithCustomProperties.add(item);
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_vec2.put(propertyName, val);
    }

    public void setCustomBool(Fixture item, String propertyName, boolean val) {
        this.m_fixturesWithCustomProperties.add(item);
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_bool.put(propertyName, val);
    }

    public void setCustomInt(Joint item, String propertyName, int val) {
        this.m_jointsWithCustomProperties.add(item);
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_int.put(propertyName, val);
    }

    public void setCustomFloat(Joint item, String propertyName, float val) {
        this.m_jointsWithCustomProperties.add(item);
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_float.put(propertyName, new Double(val));
    }

    public void setCustomString(Joint item, String propertyName, String val) {
        this.m_jointsWithCustomProperties.add(item);
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_string.put(propertyName, val);
    }

    public void setCustomVector(Joint item, String propertyName, Vec2 val) {
        this.m_jointsWithCustomProperties.add(item);
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_vec2.put(propertyName, val);
    }

    public void setCustomBool(Joint item, String propertyName, boolean val) {
        this.m_jointsWithCustomProperties.add(item);
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_bool.put(propertyName, val);
    }

    public void setCustomInt(Jb2dJsonImage item, String propertyName, int val) {
        this.m_imagesWithCustomProperties.add(item);
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_int.put(propertyName, val);
    }

    public void setCustomFloat(Jb2dJsonImage item, String propertyName, float val) {
        this.m_imagesWithCustomProperties.add(item);
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_float.put(propertyName, new Double(val));
    }

    public void setCustomString(Jb2dJsonImage item, String propertyName, String val) {
        this.m_imagesWithCustomProperties.add(item);
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_string.put(propertyName, val);
    }

    public void setCustomVector(Jb2dJsonImage item, String propertyName, Vec2 val) {
        this.m_imagesWithCustomProperties.add(item);
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_vec2.put(propertyName, val);
    }

    public void setCustomBool(Jb2dJsonImage item, String propertyName, boolean val) {
        this.m_imagesWithCustomProperties.add(item);
        this.getCustomPropertiesForItem((Object)item, (boolean)true).m_customPropertyMap_bool.put(propertyName, val);
    }

    public boolean hasCustomInt(Object item, String propertyName) {
        return this.getCustomPropertiesForItem(item, false) != null && this.getCustomPropertiesForItem((Object)item, (boolean)false).m_customPropertyMap_int.containsKey(propertyName);
    }

    public boolean hasCustomFloat(Object item, String propertyName) {
        return this.getCustomPropertiesForItem(item, false) != null && this.getCustomPropertiesForItem((Object)item, (boolean)false).m_customPropertyMap_float.containsKey(propertyName);
    }

    public boolean hasCustomString(Object item, String propertyName) {
        return this.getCustomPropertiesForItem(item, false) != null && this.getCustomPropertiesForItem((Object)item, (boolean)false).m_customPropertyMap_string.containsKey(propertyName);
    }

    public boolean hasCustomVector(Object item, String propertyName) {
        return this.getCustomPropertiesForItem(item, false) != null && this.getCustomPropertiesForItem((Object)item, (boolean)false).m_customPropertyMap_vec2.containsKey(propertyName);
    }

    public boolean hasCustomBool(Object item, String propertyName) {
        return this.getCustomPropertiesForItem(item, false) != null && this.getCustomPropertiesForItem((Object)item, (boolean)false).m_customPropertyMap_bool.containsKey(propertyName);
    }

    public int getCustomInt(Object item, String propertyName, int defaultVal) {
        Jb2dJsonCustomProperties props = this.getCustomPropertiesForItem(item, false);
        if (props == null) {
            return defaultVal;
        }
        if (props.m_customPropertyMap_int.containsKey(propertyName)) {
            return props.m_customPropertyMap_int.get(propertyName);
        }
        return defaultVal;
    }

    public float getCustomFloat(Object item, String propertyName, float defaultVal) {
        Jb2dJsonCustomProperties props = this.getCustomPropertiesForItem(item, false);
        if (props == null) {
            return defaultVal;
        }
        if (props.m_customPropertyMap_float.containsKey(propertyName)) {
            return props.m_customPropertyMap_float.get(propertyName).floatValue();
        }
        return defaultVal;
    }

    public String getCustomString(Object item, String propertyName, String defaultVal) {
        Jb2dJsonCustomProperties props = this.getCustomPropertiesForItem(item, false);
        if (props == null) {
            return defaultVal;
        }
        if (props.m_customPropertyMap_string.containsKey(propertyName)) {
            return props.m_customPropertyMap_string.get(propertyName);
        }
        return defaultVal;
    }

    public Vec2 getCustomVector(Object item, String propertyName, Vec2 defaultVal) {
        Jb2dJsonCustomProperties props = this.getCustomPropertiesForItem(item, false);
        if (props == null) {
            return defaultVal;
        }
        if (props.m_customPropertyMap_vec2.containsKey(propertyName)) {
            return props.m_customPropertyMap_vec2.get(propertyName);
        }
        return defaultVal;
    }

    public boolean getCustomBool(Object item, String propertyName, boolean defaultVal) {
        Jb2dJsonCustomProperties props = this.getCustomPropertiesForItem(item, false);
        if (props == null) {
            return defaultVal;
        }
        if (props.m_customPropertyMap_bool.containsKey(propertyName)) {
            return props.m_customPropertyMap_bool.get(propertyName);
        }
        return defaultVal;
    }

    public int getBodiesByCustomInt(String propertyName, int valueToMatch, Vector<Body> items) {
        for (Body item : this.m_bodiesWithCustomProperties) {
            if (!this.hasCustomInt(item, propertyName) || this.getCustomInt(item, propertyName, 0) != valueToMatch) continue;
            items.add(item);
        }
        return items.size();
    }

    public int getBodiesByCustomFloat(String propertyName, float valueToMatch, Vector<Body> items) {
        for (Body item : this.m_bodiesWithCustomProperties) {
            if (!this.hasCustomFloat(item, propertyName) || this.getCustomFloat(item, propertyName, 0.0f) != valueToMatch) continue;
            items.add(item);
        }
        return items.size();
    }

    public int getBodiesByCustomString(String propertyName, String valueToMatch, Vector<Body> items) {
        for (Body item : this.m_bodiesWithCustomProperties) {
            if (!this.hasCustomString(item, propertyName) || !this.getCustomString(item, propertyName, new String()).equals(valueToMatch)) continue;
            items.add(item);
        }
        return items.size();
    }

    public int getBodiesByCustomVector(String propertyName, Vec2 valueToMatch, Vector<Body> items) {
        for (Body item : this.m_bodiesWithCustomProperties) {
            if (!this.hasCustomVector(item, propertyName) || this.getCustomVector(item, propertyName, new Vec2(0.0f, 0.0f)) != valueToMatch) continue;
            items.add(item);
        }
        return items.size();
    }

    public int getBodiesByCustomBool(String propertyName, boolean valueToMatch, Vector<Body> items) {
        for (Body item : this.m_bodiesWithCustomProperties) {
            if (!this.hasCustomBool(item, propertyName) || this.getCustomBool(item, propertyName, false) != valueToMatch) continue;
            items.add(item);
        }
        return items.size();
    }

    Body getBodyByCustomInt(String propertyName, int valueToMatch) {
        for (Body item : this.m_bodiesWithCustomProperties) {
            if (!this.hasCustomInt(item, propertyName) || this.getCustomInt(item, propertyName, 0) != valueToMatch) continue;
            return item;
        }
        return null;
    }

    Body getBodyByCustomFloat(String propertyName, float valueToMatch) {
        for (Body item : this.m_bodiesWithCustomProperties) {
            if (!this.hasCustomFloat(item, propertyName) || this.getCustomFloat(item, propertyName, 0.0f) != valueToMatch) continue;
            return item;
        }
        return null;
    }

    Body getBodyByCustomString(String propertyName, String valueToMatch) {
        for (Body item : this.m_bodiesWithCustomProperties) {
            if (!this.hasCustomString(item, propertyName) || !this.getCustomString(item, propertyName, new String()).equals(valueToMatch)) continue;
            return item;
        }
        return null;
    }

    Body getBodyByCustomVector(String propertyName, Vec2 valueToMatch) {
        for (Body item : this.m_bodiesWithCustomProperties) {
            if (!this.hasCustomVector(item, propertyName) || this.getCustomVector(item, propertyName, new Vec2(0.0f, 0.0f)) != valueToMatch) continue;
            return item;
        }
        return null;
    }

    Body getBodyByCustomBool(String propertyName, boolean valueToMatch) {
        for (Body item : this.m_bodiesWithCustomProperties) {
            if (!this.hasCustomBool(item, propertyName) || this.getCustomBool(item, propertyName, false) != valueToMatch) continue;
            return item;
        }
        return null;
    }

    public int getFixturesByCustomInt(String propertyName, int valueToMatch, Vector<Fixture> items) {
        for (Fixture item : this.m_fixturesWithCustomProperties) {
            if (!this.hasCustomInt(item, propertyName) || this.getCustomInt(item, propertyName, 0) != valueToMatch) continue;
            items.add(item);
        }
        return items.size();
    }

    public int getFixturesByCustomFloat(String propertyName, float valueToMatch, Vector<Fixture> items) {
        for (Fixture item : this.m_fixturesWithCustomProperties) {
            if (!this.hasCustomFloat(item, propertyName) || this.getCustomFloat(item, propertyName, 0.0f) != valueToMatch) continue;
            items.add(item);
        }
        return items.size();
    }

    public int getFixturesByCustomString(String propertyName, String valueToMatch, Vector<Fixture> items) {
        for (Fixture item : this.m_fixturesWithCustomProperties) {
            if (!this.hasCustomString(item, propertyName) || !this.getCustomString(item, propertyName, new String()).equals(valueToMatch)) continue;
            items.add(item);
        }
        return items.size();
    }

    public int getFixturesByCustomVector(String propertyName, Vec2 valueToMatch, Vector<Fixture> items) {
        for (Fixture item : this.m_fixturesWithCustomProperties) {
            if (!this.hasCustomVector(item, propertyName) || this.getCustomVector(item, propertyName, new Vec2(0.0f, 0.0f)) != valueToMatch) continue;
            items.add(item);
        }
        return items.size();
    }

    public int getFixturesByCustomBool(String propertyName, boolean valueToMatch, Vector<Fixture> items) {
        for (Fixture item : this.m_fixturesWithCustomProperties) {
            if (!this.hasCustomBool(item, propertyName) || this.getCustomBool(item, propertyName, false) != valueToMatch) continue;
            items.add(item);
        }
        return items.size();
    }

    Fixture getFixtureByCustomInt(String propertyName, int valueToMatch) {
        for (Fixture item : this.m_fixturesWithCustomProperties) {
            if (!this.hasCustomInt(item, propertyName) || this.getCustomInt(item, propertyName, 0) != valueToMatch) continue;
            return item;
        }
        return null;
    }

    Fixture getFixtureByCustomFloat(String propertyName, float valueToMatch) {
        for (Fixture item : this.m_fixturesWithCustomProperties) {
            if (!this.hasCustomFloat(item, propertyName) || this.getCustomFloat(item, propertyName, 0.0f) != valueToMatch) continue;
            return item;
        }
        return null;
    }

    Fixture getFixtureByCustomString(String propertyName, String valueToMatch) {
        for (Fixture item : this.m_fixturesWithCustomProperties) {
            if (!this.hasCustomString(item, propertyName) || !this.getCustomString(item, propertyName, new String()).equals(valueToMatch)) continue;
            return item;
        }
        return null;
    }

    Fixture getFixtureByCustomVector(String propertyName, Vec2 valueToMatch) {
        for (Fixture item : this.m_fixturesWithCustomProperties) {
            if (!this.hasCustomVector(item, propertyName) || this.getCustomVector(item, propertyName, new Vec2(0.0f, 0.0f)) != valueToMatch) continue;
            return item;
        }
        return null;
    }

    Fixture getFixtureByCustomBool(String propertyName, boolean valueToMatch) {
        for (Fixture item : this.m_fixturesWithCustomProperties) {
            if (!this.hasCustomBool(item, propertyName) || this.getCustomBool(item, propertyName, false) != valueToMatch) continue;
            return item;
        }
        return null;
    }

    public int getJointsByCustomInt(String propertyName, int valueToMatch, Vector<Joint> items) {
        for (Joint item : this.m_jointsWithCustomProperties) {
            if (!this.hasCustomInt(item, propertyName) || this.getCustomInt(item, propertyName, 0) != valueToMatch) continue;
            items.add(item);
        }
        return items.size();
    }

    public int getJointsByCustomFloat(String propertyName, float valueToMatch, Vector<Joint> items) {
        for (Joint item : this.m_jointsWithCustomProperties) {
            if (!this.hasCustomFloat(item, propertyName) || this.getCustomFloat(item, propertyName, 0.0f) != valueToMatch) continue;
            items.add(item);
        }
        return items.size();
    }

    public int getJointsByCustomString(String propertyName, String valueToMatch, Vector<Joint> items) {
        for (Joint item : this.m_jointsWithCustomProperties) {
            if (!this.hasCustomString(item, propertyName) || !this.getCustomString(item, propertyName, new String()).equals(valueToMatch)) continue;
            items.add(item);
        }
        return items.size();
    }

    public int getJointsByCustomVector(String propertyName, Vec2 valueToMatch, Vector<Joint> items) {
        for (Joint item : this.m_jointsWithCustomProperties) {
            if (!this.hasCustomVector(item, propertyName) || this.getCustomVector(item, propertyName, new Vec2(0.0f, 0.0f)) != valueToMatch) continue;
            items.add(item);
        }
        return items.size();
    }

    public int getJointsByCustomBool(String propertyName, boolean valueToMatch, Vector<Joint> items) {
        for (Joint item : this.m_jointsWithCustomProperties) {
            if (!this.hasCustomBool(item, propertyName) || this.getCustomBool(item, propertyName, false) != valueToMatch) continue;
            items.add(item);
        }
        return items.size();
    }

    Joint getJointByCustomInt(String propertyName, int valueToMatch) {
        for (Joint item : this.m_jointsWithCustomProperties) {
            if (!this.hasCustomInt(item, propertyName) || this.getCustomInt(item, propertyName, 0) != valueToMatch) continue;
            return item;
        }
        return null;
    }

    Joint getJointByCustomFloat(String propertyName, float valueToMatch) {
        for (Joint item : this.m_jointsWithCustomProperties) {
            if (!this.hasCustomFloat(item, propertyName) || this.getCustomFloat(item, propertyName, 0.0f) != valueToMatch) continue;
            return item;
        }
        return null;
    }

    Joint getJointByCustomString(String propertyName, String valueToMatch) {
        for (Joint item : this.m_jointsWithCustomProperties) {
            if (!this.hasCustomString(item, propertyName) || !this.getCustomString(item, propertyName, new String()).equals(valueToMatch)) continue;
            return item;
        }
        return null;
    }

    Joint getJointByCustomVector(String propertyName, Vec2 valueToMatch) {
        for (Joint item : this.m_jointsWithCustomProperties) {
            if (!this.hasCustomVector(item, propertyName) || this.getCustomVector(item, propertyName, new Vec2(0.0f, 0.0f)) != valueToMatch) continue;
            return item;
        }
        return null;
    }

    Joint getJointByCustomBool(String propertyName, boolean valueToMatch) {
        for (Joint item : this.m_jointsWithCustomProperties) {
            if (!this.hasCustomBool(item, propertyName) || this.getCustomBool(item, propertyName, false) != valueToMatch) continue;
            return item;
        }
        return null;
    }

    public int getImagesByCustomInt(String propertyName, int valueToMatch, Vector<Jb2dJsonImage> items) {
        for (Jb2dJsonImage item : this.m_imagesWithCustomProperties) {
            if (!this.hasCustomInt(item, propertyName) || this.getCustomInt(item, propertyName, 0) != valueToMatch) continue;
            items.add(item);
        }
        return items.size();
    }

    public int getImagesByCustomFloat(String propertyName, float valueToMatch, Vector<Jb2dJsonImage> items) {
        for (Jb2dJsonImage item : this.m_imagesWithCustomProperties) {
            if (!this.hasCustomFloat(item, propertyName) || this.getCustomFloat(item, propertyName, 0.0f) != valueToMatch) continue;
            items.add(item);
        }
        return items.size();
    }

    public int getImagesByCustomString(String propertyName, String valueToMatch, Vector<Jb2dJsonImage> items) {
        for (Jb2dJsonImage item : this.m_imagesWithCustomProperties) {
            if (!this.hasCustomString(item, propertyName) || !this.getCustomString(item, propertyName, new String()).equals(valueToMatch)) continue;
            items.add(item);
        }
        return items.size();
    }

    public int getImagesByCustomVector(String propertyName, Vec2 valueToMatch, Vector<Jb2dJsonImage> items) {
        for (Jb2dJsonImage item : this.m_imagesWithCustomProperties) {
            if (!this.hasCustomVector(item, propertyName) || this.getCustomVector(item, propertyName, new Vec2(0.0f, 0.0f)) != valueToMatch) continue;
            items.add(item);
        }
        return items.size();
    }

    public int getImagesByCustomBool(String propertyName, boolean valueToMatch, Vector<Jb2dJsonImage> items) {
        for (Jb2dJsonImage item : this.m_imagesWithCustomProperties) {
            if (!this.hasCustomBool(item, propertyName) || this.getCustomBool(item, propertyName, false) != valueToMatch) continue;
            items.add(item);
        }
        return items.size();
    }

    Jb2dJsonImage getImageByCustomInt(String propertyName, int valueToMatch) {
        for (Jb2dJsonImage item : this.m_imagesWithCustomProperties) {
            if (!this.hasCustomInt(item, propertyName) || this.getCustomInt(item, propertyName, 0) != valueToMatch) continue;
            return item;
        }
        return null;
    }

    Jb2dJsonImage getImageByCustomFloat(String propertyName, float valueToMatch) {
        for (Jb2dJsonImage item : this.m_imagesWithCustomProperties) {
            if (!this.hasCustomFloat(item, propertyName) || this.getCustomFloat(item, propertyName, 0.0f) != valueToMatch) continue;
            return item;
        }
        return null;
    }

    Jb2dJsonImage getImageByCustomString(String propertyName, String valueToMatch) {
        for (Jb2dJsonImage item : this.m_imagesWithCustomProperties) {
            if (!this.hasCustomString(item, propertyName) || !this.getCustomString(item, propertyName, new String()).equals(valueToMatch)) continue;
            return item;
        }
        return null;
    }

    Jb2dJsonImage getImageByCustomVector(String propertyName, Vec2 valueToMatch) {
        for (Jb2dJsonImage item : this.m_imagesWithCustomProperties) {
            if (!this.hasCustomVector(item, propertyName) || this.getCustomVector(item, propertyName, new Vec2(0.0f, 0.0f)) != valueToMatch) continue;
            return item;
        }
        return null;
    }

    Jb2dJsonImage getImageByCustomBool(String propertyName, boolean valueToMatch) {
        for (Jb2dJsonImage item : this.m_imagesWithCustomProperties) {
            if (!this.hasCustomBool(item, propertyName) || this.getCustomBool(item, propertyName, false) != valueToMatch) continue;
            return item;
        }
        return null;
    }

    protected JSONArray writeCustomPropertiesToJson(Object item) throws JSONException {
        JSONObject propValue;
        JSONArray customPropertiesValue = new JSONArray();
        Jb2dJsonCustomProperties props = this.getCustomPropertiesForItem(item, false);
        if (props == null) {
            return customPropertiesValue;
        }
        int i = 0;
        for (Map.Entry<String, Integer> entry : props.m_customPropertyMap_int.entrySet()) {
            propValue = new JSONObject();
            propValue.put("name", entry.getKey());
            propValue.put("int", entry.getValue());
            customPropertiesValue.put(i++, propValue);
        }
        for (Map.Entry<String, Number> entry : props.m_customPropertyMap_float.entrySet()) {
            propValue = new JSONObject();
            propValue.put("name", entry.getKey());
            propValue.put("float", entry.getValue());
            customPropertiesValue.put(i++, propValue);
        }
        for (Map.Entry<String, Object> entry : props.m_customPropertyMap_string.entrySet()) {
            propValue = new JSONObject();
            propValue.put("name", entry.getKey());
            propValue.put("string", entry.getValue());
            customPropertiesValue.put(i++, propValue);
        }
        for (Map.Entry<String, Object> entry : props.m_customPropertyMap_vec2.entrySet()) {
            propValue = new JSONObject();
            propValue.put("name", entry.getKey());
            this.vecToJson("vec2", (Vec2)entry.getValue(), propValue);
            customPropertiesValue.put(i++, propValue);
        }
        for (Map.Entry<String, Object> entry : props.m_customPropertyMap_bool.entrySet()) {
            propValue = new JSONObject();
            propValue.put("name", entry.getKey());
            propValue.put("bool", entry.getValue());
            customPropertiesValue.put(i++, propValue);
        }
        return customPropertiesValue;
    }

    protected void readCustomPropertiesFromJson(Body item, JSONObject value) throws JSONException {
        if (item == null) {
            return;
        }
        if (!value.has("customProperties")) {
            return;
        }
        int i = 0;
        JSONArray propValues = value.getJSONArray("customProperties");
        if (propValues != null) {
            int numPropValues = propValues.length();
            i = 0;
            while (i < numPropValues) {
                JSONObject propValue = propValues.getJSONObject(i);
                String propertyName = propValue.getString("name");
                if (propValue.has("int")) {
                    this.setCustomInt(item, propertyName, propValue.getInt("int"));
                }
                if (propValue.has("float")) {
                    this.setCustomFloat(item, propertyName, (float)propValue.getDouble("float"));
                }
                if (propValue.has("string")) {
                    this.setCustomString(item, propertyName, propValue.getString("string"));
                }
                if (propValue.has("vec2")) {
                    this.setCustomVector(item, propertyName, this.jsonToVec("vec2", propValue));
                }
                if (propValue.has("bool")) {
                    this.setCustomBool(item, propertyName, propValue.getBoolean("bool"));
                }
                ++i;
            }
        }
    }

    protected void readCustomPropertiesFromJson(Fixture item, JSONObject value) throws JSONException {
        if (item == null) {
            return;
        }
        if (!value.has("customProperties")) {
            return;
        }
        int i = 0;
        JSONArray propValues = value.getJSONArray("customProperties");
        if (propValues != null) {
            int numPropValues = propValues.length();
            i = 0;
            while (i < numPropValues) {
                JSONObject propValue = propValues.getJSONObject(i);
                String propertyName = propValue.getString("name");
                if (propValue.has("int")) {
                    this.setCustomInt(item, propertyName, propValue.getInt("int"));
                }
                if (propValue.has("float")) {
                    this.setCustomFloat(item, propertyName, (float)propValue.getDouble("float"));
                }
                if (propValue.has("string")) {
                    this.setCustomString(item, propertyName, propValue.getString("string"));
                }
                if (propValue.has("vec2")) {
                    this.setCustomVector(item, propertyName, this.jsonToVec("vec2", propValue));
                }
                if (propValue.has("bool")) {
                    this.setCustomBool(item, propertyName, propValue.getBoolean("bool"));
                }
                ++i;
            }
        }
    }

    protected void readCustomPropertiesFromJson(Joint item, JSONObject value) throws JSONException {
        if (item == null) {
            return;
        }
        if (!value.has("customProperties")) {
            return;
        }
        int i = 0;
        JSONArray propValues = value.getJSONArray("customProperties");
        if (propValues != null) {
            int numPropValues = propValues.length();
            i = 0;
            while (i < numPropValues) {
                JSONObject propValue = propValues.getJSONObject(i);
                String propertyName = propValue.getString("name");
                if (propValue.has("int")) {
                    this.setCustomInt(item, propertyName, propValue.getInt("int"));
                }
                if (propValue.has("float")) {
                    this.setCustomFloat(item, propertyName, (float)propValue.getDouble("float"));
                }
                if (propValue.has("string")) {
                    this.setCustomString(item, propertyName, propValue.getString("string"));
                }
                if (propValue.has("vec2")) {
                    this.setCustomVector(item, propertyName, this.jsonToVec("vec2", propValue));
                }
                if (propValue.has("bool")) {
                    this.setCustomBool(item, propertyName, propValue.getBoolean("bool"));
                }
                ++i;
            }
        }
    }

    protected void readCustomPropertiesFromJson(Jb2dJsonImage item, JSONObject value) throws JSONException {
        if (item == null) {
            return;
        }
        if (!value.has("customProperties")) {
            return;
        }
        int i = 0;
        JSONArray propValues = value.getJSONArray("customProperties");
        if (propValues != null) {
            int numPropValues = propValues.length();
            i = 0;
            while (i < numPropValues) {
                JSONObject propValue = propValues.getJSONObject(i);
                String propertyName = propValue.getString("name");
                if (propValue.has("int")) {
                    this.setCustomInt(item, propertyName, propValue.getInt("int"));
                }
                if (propValue.has("float")) {
                    this.setCustomFloat(item, propertyName, (float)propValue.getDouble("float"));
                }
                if (propValue.has("string")) {
                    this.setCustomString(item, propertyName, propValue.getString("string"));
                }
                if (propValue.has("vec2")) {
                    this.setCustomVector(item, propertyName, this.jsonToVec("vec2", propValue));
                }
                if (propValue.has("bool")) {
                    this.setCustomBool(item, propertyName, propValue.getBoolean("bool"));
                }
                ++i;
            }
        }
    }

    protected void readCustomPropertiesFromJson(World item, JSONObject value) throws JSONException {
        if (item == null) {
            return;
        }
        if (!value.has("customProperties")) {
            return;
        }
        int i = 0;
        JSONArray propValues = value.getJSONArray("customProperties");
        if (propValues != null) {
            int numPropValues = propValues.length();
            i = 0;
            while (i < numPropValues) {
                JSONObject propValue = propValues.getJSONObject(i);
                String propertyName = propValue.getString("name");
                if (propValue.has("int")) {
                    this.setCustomInt(item, propertyName, propValue.getInt("int"));
                }
                if (propValue.has("float")) {
                    this.setCustomFloat(item, propertyName, (float)propValue.getDouble("float"));
                }
                if (propValue.has("string")) {
                    this.setCustomString(item, propertyName, propValue.getString("string"));
                }
                if (propValue.has("vec2")) {
                    this.setCustomVector(item, propertyName, this.jsonToVec("vec2", propValue));
                }
                if (propValue.has("bool")) {
                    this.setCustomBool(item, propertyName, propValue.getBoolean("bool"));
                }
                ++i;
            }
        }
    }

    public class Jb2dJsonCustomProperties {
        Map<String, Integer> m_customPropertyMap_int = new HashMap<String, Integer>();
        Map<String, Double> m_customPropertyMap_float = new HashMap<String, Double>();
        Map<String, String> m_customPropertyMap_string = new HashMap<String, String>();
        Map<String, Vec2> m_customPropertyMap_vec2 = new HashMap<String, Vec2>();
        Map<String, Boolean> m_customPropertyMap_bool = new HashMap<String, Boolean>();
    }
}

