/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.testbed.framework.TestbedTest;

public class CompoundShapes
extends TestbedTest {
    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean argDeserialized) {
        Body body;
        BodyDef bd;
        float x;
        int i;
        if (argDeserialized) {
            return;
        }
        BodyDef bd2 = new BodyDef();
        bd2.position.set(0.0f, 0.0f);
        Body body2 = this.getWorld().createBody(bd2);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(50.0f, 0.0f), new Vec2(-50.0f, 0.0f));
        body2.createFixture(shape, 0.0f);
        CircleShape circle1 = new CircleShape();
        circle1.m_radius = 0.5f;
        circle1.m_p.set(-0.5f, 0.5f);
        CircleShape circle2 = new CircleShape();
        circle2.m_radius = 0.5f;
        circle2.m_p.set(0.5f, 0.5f);
        for (i = 0; i < 10; ++i) {
            x = MathUtils.randomFloat(-0.1f, 0.1f);
            bd = new BodyDef();
            bd.type = BodyType.DYNAMIC;
            bd.position.set(x + 5.0f, 1.05f + 2.5f * (float)i);
            bd.angle = MathUtils.randomFloat((float)(-Math.PI), (float)Math.PI);
            body = this.getWorld().createBody(bd);
            body.createFixture(circle1, 2.0f);
            body.createFixture(circle2, 0.0f);
        }
        PolygonShape polygon1 = new PolygonShape();
        polygon1.setAsBox(0.25f, 0.5f);
        PolygonShape polygon2 = new PolygonShape();
        polygon2.setAsBox(0.25f, 0.5f, new Vec2(0.0f, -0.5f), 1.5707964f);
        for (i = 0; i < 10; ++i) {
            x = MathUtils.randomFloat(-0.1f, 0.1f);
            bd = new BodyDef();
            bd.type = BodyType.DYNAMIC;
            bd.position.set(x - 5.0f, 1.05f + 2.5f * (float)i);
            bd.angle = MathUtils.randomFloat((float)(-Math.PI), (float)Math.PI);
            body = this.getWorld().createBody(bd);
            body.createFixture(polygon1, 2.0f);
            body.createFixture(polygon2, 2.0f);
        }
        Transform xf1 = new Transform();
        xf1.q.set(1.1070973f);
        Rot.mulToOut(xf1.q, new Vec2(1.0f, 0.0f), xf1.p);
        Vec2[] vertices = new Vec2[3];
        PolygonShape triangle1 = new PolygonShape();
        vertices[0] = Transform.mul(xf1, new Vec2(-1.0f, 0.0f));
        vertices[1] = Transform.mul(xf1, new Vec2(1.0f, 0.0f));
        vertices[2] = Transform.mul(xf1, new Vec2(0.0f, 0.5f));
        triangle1.set(vertices, 3);
        Transform xf2 = new Transform();
        xf2.q.set(-1.1070973f);
        Rot.mulToOut(xf2.q, new Vec2(-1.0f, 0.0f), xf2.p);
        PolygonShape triangle2 = new PolygonShape();
        vertices[0] = Transform.mul(xf2, new Vec2(-1.0f, 0.0f));
        vertices[1] = Transform.mul(xf2, new Vec2(1.0f, 0.0f));
        vertices[2] = Transform.mul(xf2, new Vec2(0.0f, 0.5f));
        triangle2.set(vertices, 3);
        for (int i2 = 0; i2 < 10; ++i2) {
            float x2 = MathUtils.randomFloat(-0.1f, 0.1f);
            BodyDef bd3 = new BodyDef();
            bd3.type = BodyType.DYNAMIC;
            bd3.position.set(x2, 2.05f + 2.5f * (float)i2);
            bd3.angle = 0.0f;
            Body body3 = this.getWorld().createBody(bd3);
            body3.createFixture(triangle1, 2.0f);
            body3.createFixture(triangle2, 2.0f);
        }
        PolygonShape bottom = new PolygonShape();
        bottom.setAsBox(1.5f, 0.15f);
        PolygonShape left = new PolygonShape();
        left.setAsBox(0.15f, 2.7f, new Vec2(-1.45f, 2.35f), 0.2f);
        PolygonShape right = new PolygonShape();
        right.setAsBox(0.15f, 2.7f, new Vec2(1.45f, 2.35f), -0.2f);
        BodyDef bd4 = new BodyDef();
        bd4.type = BodyType.DYNAMIC;
        bd4.position.set(0.0f, 2.0f);
        Body body4 = this.getWorld().createBody(bd4);
        body4.createFixture(bottom, 4.0f);
        body4.createFixture(left, 4.0f);
        body4.createFixture(right, 4.0f);
    }

    @Override
    public String getTestName() {
        return "Compound Shapes";
    }
}

