#include "Arduino.h"
#include <SoftwareSerial.h>
#include <SPI.h>
#include <nRF24L01.h>
#include <RF24.h>
#include "printf.h"

// Connect the GPS RX/TX to arduino pins 3 and 5
SoftwareSerial ss = SoftwareSerial(3,5);

const uint64_t pipeOut = 0xE8E8F0F0E1LL;

RF24 radio(9, 10);

float currentLat = 0;
float currentLon = 0;

// The sizeof this struct should not exceed 32 bytes
struct MyData {
  byte throttle;
  byte yaw;
  byte pitch;
  byte roll;
  byte switches;
  float lat;
  float lon;
};

MyData data;
const unsigned char UBX_HEADER[] = { 0xB5, 0x62 };

struct NAV_POSLLH {
  unsigned char cls;
  unsigned char id;
  unsigned short len;
  unsigned long iTOW;
  long lon;
  long lat;
  long height;
  long hMSL;
  unsigned long hAcc;
  unsigned long vAcc;
};

NAV_POSLLH posllh;

void calcChecksum(unsigned char* CK) {
  memset(CK, 0, 2);
  for (int i = 0; i < (int)sizeof(NAV_POSLLH); i++) {
    CK[0] += ((unsigned char*)(&posllh))[i];
    CK[1] += CK[0];
  }
}

bool processGPS() {
  static int fpos = 0;
  static unsigned char checksum[2];
  const int payloadSize = sizeof(NAV_POSLLH);

  while ( ss.available() ) {
    byte c = ss.read();
    if ( fpos < 2 ) {
      if ( c == UBX_HEADER[fpos] )
        fpos++;
      else
        fpos = 0;
    }
    else {
      if ( (fpos-2) < payloadSize )
        ((unsigned char*)(&posllh))[fpos-2] = c;

      fpos++;

      if ( fpos == (payloadSize+2) ) {
        calcChecksum(checksum);
      }
      else if ( fpos == (payloadSize+3) ) {
        if ( c != checksum[0] )
          fpos = 0;
      }
      else if ( fpos == (payloadSize+4) ) {
        fpos = 0;
        if ( c == checksum[1] ) {
          return true;
        }
      }
      else if ( fpos > (payloadSize+4) ) {
        fpos = 0;
      }
    }
  }
  return false;
}

void setup()
{
  //Serial.begin(9600);
  ss.begin(9600);

  printf_begin();
  
  radio.begin();
  radio.setAutoAck(false);
  radio.setDataRate(RF24_250KBPS);

  radio.openWritingPipe(pipeOut);
  
  //radio.printDetails();

  memset(&data, 0, sizeof(MyData));
  data.throttle = 127;
  data.yaw = 127;
  data.pitch = 127;
  data.roll = 127;
  
  //Serial.println("Starting...");
}

void loop()
{
  if ( processGPS() ) {
    data.lat = posllh.lat / 10000000.0f;
    data.lon = posllh.lon / 10000000.0f;
    //displayInfo();
  }
  
  radio.write(&data, sizeof(MyData));
  
}

void displayInfo()
{
    Serial.print(" lat/lon: "); Serial.print(data.lat); Serial.print(","); Serial.println(data.lon);
}
