
//#define USE_ACK_PAYLOAD

const uint64_t pipeIn =  0xE8E8F0F0E1LL;

struct MyData {
  byte throttle;
  byte yaw;
  byte pitch;
  byte roll;
  byte switches; // bitflag
  float lat;
  float lon;
};

MyData data;

#ifdef USE_ACK_PAYLOAD
struct MyAckPayload {
  float lat;
  float lon;
  int heading;
  int16_t pitch;
  int16_t roll;  
  int32_t alt;
  byte flags;
};

MyAckPayload ackPayload;
#endif //USE_ACK_PAYLOAD

void resetData() {
  data.throttle = 127;
  data.yaw = 127;
  data.pitch = 127;
  data.roll = 127;
  data.switches = 0;
  data.lat = 0;
  data.lon = 0;
  tagLoc.lat = 0;
  tagLoc.lon = 0;
}

RF24 radio(9, 10);

void radio_setup() {
  Serial.print("Radio...");
  radio.begin();
  radio.setAutoAck(false);
  radio.setDataRate(RF24_250KBPS);

#ifdef USE_ACK_PAYLOAD
  radio.setAutoAck(true);
  radio.enableAckPayload();
#endif

  radio.openReadingPipe(1,pipeIn);
  radio.startListening();
  Serial.println("done.");
}

void radio_loop() {
  static bool haveRadio = false;
  static unsigned long lastRecvTime = 0;

  unsigned long now = millis();
  bool hadRadio = haveRadio;

#ifdef USE_ACK_PAYLOAD    
  ackPayload.lat = currentLoc.lat;
  ackPayload.lon = currentLoc.lon;
  ackPayload.heading = (int)heading;
  
  //faked
  ackPayload.pitch = 0;
  ackPayload.roll = 0;
  ackPayload.alt = 0;
  ackPayload.flags = 0;
#endif

  while ( radio.available() ) {    
#ifdef USE_ACK_PAYLOAD
    radio.writeAckPayload(1, &ackPayload, sizeof(MyAckPayload));
#endif
    radio.read(&data, sizeof(MyData));
    lastRecvTime = now;
    haveRadio = true;
    tagLoc.lat = data.lat;
    tagLoc.lon = data.lon;
    //Serial.println("rasdf");
  }

  if ( now - lastRecvTime > 1000 ) {
    haveRadio = false;
    resetData();
  }
  
  if ( !hadRadio && haveRadio ) 
    Serial.println("\n***** Gained radio contact *****\n");
  else if ( hadRadio && !haveRadio )
    Serial.println("\n***** Lost radio contact *****\n");
}
