#include <SPI.h>
#include <Wire.h>
#include <nRF24L01.h>
#include <RF24.h>
#include <Servo.h>
#include <EEPROM.h>

#include "printf.h"
#include "Data.h"
#include "GPS.h"
#include "Compass.h"
#include "Radio.h"

Servo throttleServo;
Servo steeringServo;

/**************************************************/

void twitchWheels(int length)
{
  for (int i = 0; i < length; i++) {
    applySteering(50);
    delay(1);
  }
  for (int i = 0; i < length; i++) {
    applySteering(130);
    delay(1);
  }
}

/**************************************************/

void setup() {

  Wire.begin();

  Serial.begin(9600);
  printf_begin();

  Serial.println("Starting...");
  
  gps_setup();
  compass_setup();
  radio_setup();

  radio.printDetails();

  throttleServo.attach(5);
  steeringServo.attach(6);

  pinMode( 7, INPUT );
  if ( digitalRead(7) ) {
    twitchWheels(750);
    //initLocation();
    calibrateCompass();  
    twitchWheels(750);
  }
  else {
    twitchWheels(250);
    twitchWheels(250);
    twitchWheels(250);
    loadCompass();
  }
}

/**************************************************/

void initLocation() {

#define HOME_LOCATION_READINGS 10

  Serial.println("Starting location init...");
  
  unsigned long count = gpsInfo.validCount;
  int numReadings = 0;
  float lat = 0;
  float lon = 0;
  while (numReadings < HOME_LOCATION_READINGS) {
    gps_loop();
    if ( gpsInfo.validCount > count ) {
      lat += gpsInfo.lat;
      lon += gpsInfo.lon;
      Serial.println("Got reading...");
      numReadings++;
      count = gpsInfo.validCount;
    }
  }
 
  float d = (1/(float)HOME_LOCATION_READINGS);
  currentLoc.lat = lat * d;
  currentLoc.lon = lon * d;
  
  homeLoc.lat = currentLoc.lat;
  homeLoc.lon = currentLoc.lon;

  /*******************/  
  // river
  //targetLoc.lat = 35.615011;
  //targetLoc.lon = 139.612323;

  // shibuya
  //targetLoc.lat = 35.656882;
  //targetLoc.lon = 139.701172;
  /*******************/
  
  char buf[16];
  Serial.print("Home location set as: ");
  dtostrf(homeLoc.lat, 0, 7, buf);
  Serial.print(buf);
  Serial.print(", ");
  dtostrf(homeLoc.lon, 0, 7, buf);
  Serial.println(buf);
  
}

/**************************************************/

int fullSpeed = 170;
int turnSpeed = 110;
int stopSpeed = 90;
int startSpeed = 95;

void autoControl() {

  if ( tagLoc.lat == 0 || currentLoc.lat == 0 ) {
    throttleServo.write(90);
    steeringServo.write(90);
    return;
  }  

  static float autoThrottle = 90;
  int autoSteer = 90;
  
  float turn = bearing - heading;
  while (turn < -180) turn += 360;
  while (turn >  180) turn -= 360;

  autoSteer = map(2 * turn, 180, -180, 0, 180);
  autoSteer = constrain(autoSteer, 40, 140);

  float angleError = abs(turn); // value between 0 - 180

  /*
  // turn and stop
  int t = startSpeed + 0.4 * angleError;
  */
  
  // drive to location
  int range = fullSpeed - turnSpeed;
  float fullSpeedFractionAllowed = (180 - angleError) / 180.0f;
  int t = turnSpeed + fullSpeedFractionAllowed * range;
  if ( distance < 8 ) {
    int wouldBeSpeed = t - stopSpeed;
    wouldBeSpeed *= distance / 8.0f;
    t = stopSpeed + wouldBeSpeed;
  }
  t = constrain(t, stopSpeed, fullSpeed);  
  
  float d = t - autoThrottle;
  d = constrain(d, -0.01, 0.01);
  autoThrottle += d;
  
  autoThrottle = constrain(t, stopSpeed, fullSpeed);

  throttleServo.write(autoThrottle);
  steeringServo.write(autoSteer);
}

/**************************************************/

void manualControl() {
  int s = map(data.roll, 0, 255, 130, 50);
  int t = map(data.throttle, 0, 255, 40, 140);
  throttleServo.write(t);
  applySteering(s);
}

void applySteering(int s) {
  s = 180 - s - 7;
  static float lastSteering = 90;
  float thisSteering = s;
  thisSteering = thisSteering * 0.05 + lastSteering * 0.95;
  steeringServo.write((int)thisSteering);
  lastSteering = thisSteering;
  //steeringServo.write(s);
}

/**************************************************/

void loop() { // run over and over

  radio_loop();
  gps_loop();
  compass_loop();

  static bool wasAuto = false;
  bool isAuto = (data.switches & 0x01);
  if ( !wasAuto && isAuto ) 
    Serial.println("Switched to auto");
  else if ( wasAuto && !isAuto )
    Serial.println("Switched to manual");

  wasAuto = isAuto;

  //if (data.switches & 0x01)
    autoControl();
  //else
  //  manualControl();
    
}


